/*
 * Decompiled with CFR 0.152.
 */
package ambience.ldapsso;

import ambience.ldapsso.LDAPBindLookup$;
import ambience.ldapsso.LDAPLookup;
import ambience.ldapsso.LDAPUserDB;
import ambience.simplesso.server.ServerModel;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class LDAPBindLookup
implements LDAPLookup,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LDAPBindLookup.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final LDAPUserDB.LDAPConfig ldapConfig;
    private final String EscapeChars;

    public static InitialLdapContext buildContext(LDAPUserDB.LDAPConfig lDAPConfig, String string, String string2) {
        return LDAPBindLookup$.MODULE$.buildContext(lDAPConfig, string, string2);
    }

    public LDAPBindLookup(LDAPUserDB.LDAPConfig ldapConfig) {
        this.ldapConfig = ldapConfig;
        this.EscapeChars = "";
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String EscapeChars() {
        return this.EscapeChars;
    }

    @Override
    public Task<Option<ServerModel.UserRecord>> matches(String name, String password) {
        Option<ServerModel.Email> option = this.isValid(name, password);
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            String email = object == null ? null : ((ServerModel.Email)object).value();
            String sub = ServerModel.Sub$.MODULE$.apply(name);
            String json = ServerModel.Json$.MODULE$.apply("{}");
            return Task$.MODULE$.now((Object)Some$.MODULE$.apply((Object)ServerModel.UserRecord$.MODULE$.apply(sub, name, email, false, json)));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Option<ServerModel.Email> isValid(String user, String password) {
        Option<ServerModel.Email> option;
        block6: {
            if (password.trim().isEmpty()) {
                return None$.MODULE$;
            }
            try {
                InitialLdapContext userContext = LDAPBindLookup$.MODULE$.buildContext(this.ldapConfig, this.ldapConfig.bind().user(), Crypt$.MODULE$.encPrefixDecrypt(this.ldapConfig.bind().password()));
                BasicAttributes attrs = new BasicAttributes(this.ldapConfig.uidAttribute(), user);
                Option<SearchResult> option2 = this.findSearchResult(userContext, this.ldapConfig.users(), attrs);
                if (option2 instanceof Some) {
                    SearchResult sr = (SearchResult)((Some)option2).value();
                    option = this.doValidate(user, password, sr);
                    break block6;
                }
                if (None$.MODULE$.equals(option2)) {
                    option = None$.MODULE$;
                    break block6;
                }
                throw new MatchError(option2);
            }
            catch (NullPointerException np) {
                this.log().error(() -> LDAPBindLookup.isValid$$anonfun$1(np), (Throwable)np, Line$.MODULE$.apply(65), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.isValid"));
                option = None$.MODULE$;
            }
            catch (Exception ex) {
                this.log().info(() -> LDAPBindLookup.isValid$$anonfun$2(ex), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.isValid"));
                option = None$.MODULE$;
            }
        }
        return option;
    }

    public Option<SearchResult> findSearchResult(InitialLdapContext userContext, List<String> userOUs, BasicAttributes attrs) {
        List<String> list = userOUs;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String head = (String)colon2.head();
            List tail = list3;
            List ret = CollectionConverters$.MODULE$.EnumerationHasAsScala(userContext.search(head, (Attributes)attrs)).asScala().toList();
            if (this.ldapConfig.debug()) {
                this.log().info(() -> LDAPBindLookup.findSearchResult$$anonfun$1(head, attrs, ret), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.findSearchResult"));
            }
            List list4 = ret;
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list5 = list4;
            if (!(nil$2 != null ? !nil$2.equals(list5) : list5 != null)) {
                return this.findSearchResult(userContext, (List<String>)tail, attrs);
            }
            if (list4 instanceof .colon.colon) {
                List list6 = ((.colon.colon)list4).next$access$1();
                SearchResult sr = (SearchResult)((.colon.colon)list4).head();
                return Some$.MODULE$.apply((Object)sr);
            }
            throw new MatchError((Object)list4);
        }
        throw new MatchError(list);
    }

    public Option<ServerModel.Email> doValidate(String user, String password, SearchResult sr) {
        String distinguishedName = sr.getNameInNamespace();
        Attributes attrs = (Attributes)Option$.MODULE$.apply((Object)sr.getAttributes()).getOrElse(LDAPBindLookup::$anonfun$1);
        Option optMail = Try$.MODULE$.apply(() -> this.$anonfun$2(attrs)).toOption();
        this.log().info(() -> LDAPBindLookup.doValidate$$anonfun$1(user, distinguishedName, optMail), Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.doValidate"));
        if (optMail.isEmpty()) {
            this.log().info(() -> LDAPBindLookup.doValidate$$anonfun$2(attrs), Line$.MODULE$.apply(93), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.doValidate"));
        }
        if (this.checkActualPassword(distinguishedName, password)) {
            Option option = optMail;
            if (option instanceof Some) {
                String m = (String)((Some)option).value();
                return Some$.MODULE$.apply((Object)new ServerModel.Email(ServerModel.Email$.MODULE$.apply(m)));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> LDAPBindLookup.doValidate$$anonfun$3(distinguishedName), Line$.MODULE$.apply(98), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.doValidate"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        }
        return None$.MODULE$;
    }

    public boolean checkActualPassword(String dn, String pass) {
        String safePass = this.escape(pass);
        Try try_ = Try$.MODULE$.apply(() -> this.checkActualPassword$$anonfun$1(dn, safePass));
        if (try_ instanceof Success) {
            if (this.ldapConfig.debug()) {
                this.log().info(() -> LDAPBindLookup.checkActualPassword$$anonfun$2(dn), Line$.MODULE$.apply(109), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.checkActualPassword"));
            }
            return true;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            this.log().info(() -> LDAPBindLookup.checkActualPassword$$anonfun$3(dn, ex), Line$.MODULE$.apply(112), FullName$.MODULE$.apply("ambience.ldapsso.LDAPBindLookup.checkActualPassword"));
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public String escape(String pass) {
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(pass.replace("\n", "").replace("\t", "")), (Function1 & Serializable)ch -> this.escape$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch))).mkString("");
    }

    public List<Object> escapeCh(char ch) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.EscapeChars()), ch)) {
            return (List)new .colon.colon((Object)BoxesRunTime.boxToCharacter((char)'\\'), (List)new .colon.colon((Object)BoxesRunTime.boxToCharacter((char)ch), (List)Nil$.MODULE$));
        }
        return (List)new .colon.colon((Object)BoxesRunTime.boxToCharacter((char)ch), (List)Nil$.MODULE$);
    }

    private static final Object isValid$$anonfun$1(NullPointerException np$1) {
        return "isValid logic error: " + np$1;
    }

    private static final Object isValid$$anonfun$2(Exception ex$1) {
        return "isValid fails with: " + ex$1;
    }

    private static final Object findSearchResult$$anonfun$1(String head$1, BasicAttributes attrs$1, List ret$1) {
        return "findSearchResult(" + head$1 + "," + attrs$1 + ") returns " + ret$1.mkString("\n");
    }

    private static final Attributes $anonfun$1() {
        return new BasicAttributes();
    }

    private final String $anonfun$2(Attributes attrs$2) {
        return attrs$2.get(this.ldapConfig.mailAttribute()).get().toString();
    }

    private static final Object doValidate$$anonfun$1(String user$1, String distinguishedName$1, Option optMail$1) {
        return "Lookup of " + user$1 + " gives us " + distinguishedName$1 + " with mail " + optMail$1;
    }

    private static final Object doValidate$$anonfun$2(Attributes attrs$3) {
        return "Available attributes: " + CollectionConverters$.MODULE$.EnumerationHasAsScala(attrs$3.getIDs()).asScala().toList().mkString(",");
    }

    private static final Object doValidate$$anonfun$3(String distinguishedName$2) {
        return "Password valid, but no email found for " + distinguishedName$2;
    }

    private final InitialLdapContext checkActualPassword$$anonfun$1(String dn$1, String safePass$1) {
        return LDAPBindLookup$.MODULE$.buildContext(this.ldapConfig, dn$1, safePass$1);
    }

    private static final Object checkActualPassword$$anonfun$2(String dn$2) {
        return "checkActualPassword for " + dn$2 + " succeeds";
    }

    private static final Object checkActualPassword$$anonfun$3(String dn$3, Throwable ex$2) {
        return "checkActualPassword for " + dn$3 + " fails with " + ex$2;
    }

    private final /* synthetic */ List escape$$anonfun$1(char ch) {
        return this.escapeCh(ch);
    }
}

