/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.daemon;

import ambience.SystemScheduler$;
import ambience.api.Lifecycle;
import ambience.etl.daemon.AuditHelper$;
import ambience.etl.daemon.DaemonConfig$;
import ambience.etl.daemon.DaemonEvent;
import ambience.etl.daemon.DaemonEvent$;
import ambience.etl.daemon.DaemonLogger;
import ambience.etl.daemon.DaemonLoop$;
import ambience.etl.daemon.DaemonManager$;
import ambience.etl.daemon.DaemonRunner;
import ambience.etl.daemon.DaemonRunner$;
import ambience.etl.daemon.DaemonRunner$Autoplay$;
import ambience.etl.daemon.DaemonRunner$Start$;
import ambience.etl.daemon.DaemonUtil$;
import ambience.etl.daemon.Model;
import ambience.etl.daemon.action.all.StopAllAction;
import ambience.etl.daemon.sys.settings.SystemSettings$;
import ambience.framework.EventBus;
import ambience.framework.EventBus$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.reactive.Observable;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.concurrent.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DaemonExecutor$
implements LoggingHelper2,
DaemonLogger,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DaemonExecutor$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final AtomicBoolean lifecycleRestartRequested;
    private static final Map<Model.DaemonId, DaemonRunner> currentDaemons;
    private static final Observable eventsTask;
    public static final DaemonExecutor$ MODULE$;

    private DaemonExecutor$() {
    }

    static {
        MODULE$ = new DaemonExecutor$();
        lifecycleRestartRequested = AtomicBoolean$.MODULE$.apply(false);
        ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).onRestartRequest(MODULE$.lifecycleRestartRequest());
        currentDaemons = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        eventsTask = EventBus$.MODULE$.events((Function1 & Serializable)msg -> DaemonLoop$.MODULE$.filterNow((EventBus.Message)msg), 100).filterEval((Function1 & Serializable)_$1 -> this.isDaemonRunner());
        MODULE$.eventsTask().filter((Function1 & Serializable)_$2 -> this.canRunDaemons()).mapEval((Function1 & Serializable)msg -> this.eventBusUpdate(DaemonEvent$.MODULE$.extractEvent(msg.eventType()), msg.doc())).completedL().onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> this.error("DaemonExecutor event bus failed " + ex.getMessage())).runAsyncAndForget(SystemScheduler$.MODULE$.global());
        MODULE$.eventsTask().filter((Function1 & Serializable)msg -> DaemonEvent$.MODULE$.islifecycleRestartEvent(msg.eventType())).mapEval((Function1 & Serializable)_$3 -> this.eventLifecycleRestartUpdate()).completedL().onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> this.error("LifecycleRestart event bus failed " + ex.getMessage())).runAsyncAndForget(SystemScheduler$.MODULE$.global());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DaemonExecutor$.class);
    }

    public Observable<EventBus.Message> eventsTask() {
        return eventsTask;
    }

    public Task<BoxedUnit> eventBusUpdate(DaemonEvent eventType, Document doc) {
        DaemonEvent daemonEvent = eventType;
        if (daemonEvent instanceof DaemonEvent.RunningDaemon) {
            DaemonEvent.RunningDaemon e = (DaemonEvent.RunningDaemon)daemonEvent;
            return this.handleRunningDaemonEvent(e.id());
        }
        if (daemonEvent instanceof DaemonEvent.Start) {
            DaemonEvent.Start e = (DaemonEvent.Start)daemonEvent;
            return this.startDaemonByAction(e);
        }
        if (daemonEvent instanceof DaemonEvent.Reclaim) {
            DaemonEvent.Reclaim e = (DaemonEvent.Reclaim)daemonEvent;
            return this.startReclaimedDaemon(e.id());
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> eventLifecycleRestartUpdate() {
        return this.infoT("Lifecycle Restart Event received").map((Function1)(JProcedure1 & Serializable)_$4 -> lifecycleRestartRequested.set(true));
    }

    public Task<Object> isDaemonRunner() {
        return SystemSettings$.MODULE$.isDaemonRunner();
    }

    private Task<BoxedUnit> lifecycleRestartRequest() {
        return this.infoT("Lifecycle Restart Request received").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(DaemonExecutor$::lifecycleRestartRequest$$anonfun$1$$anonfun$1).flatMap((Function1 & Serializable)isRestart -> DaemonExecutor$.lifecycleRestartRequest$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)isRestart)));
        });
    }

    public Task<BoxedUnit> fireLifecycleRestartEvent(boolean isRestart) {
        if (!isRestart) {
            return DaemonEvent$.MODULE$.fireLifecycleRestartEvent();
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> lifecycleRestartStopAll() {
        return this.debugT("lifecycleRestartStopAll").$greater$greater(DaemonExecutor$::lifecycleRestartStopAll$$anonfun$1);
    }

    public Task<BoxedUnit> startPreferredDaemons(boolean isStartup) {
        if (this.canRunDaemons()) {
            return this.debugT("Starting Preferred Daemons").$greater$greater(() -> DaemonExecutor$.startPreferredDaemons$$anonfun$1(isStartup));
        }
        return Task$.MODULE$.unit();
    }

    public Task<Option<Model.DaemonId>> startNonPreferredDaemon() {
        if (!lifecycleRestartRequested.get()) {
            return DaemonManager$.MODULE$.takeOneNonPreferredDaemon(this.getCurrentDaemonsIds()).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Object object = ((Some)option).value();
                    String id = object == null ? null : ((Model.DaemonId)object).value();
                    return MODULE$.startNonPreferredDaemon(id).map((Function1 & Serializable)_$6 -> {
                        MODULE$.info("Started Non Preferred Daemon " + id);
                        AuditHelper$.MODULE$.send(true, "DaemonExecutor", "Started Non Preferred Daemon", (Option<String>)Some$.MODULE$.apply((Object)id));
                        return Some$.MODULE$.apply((Object)new Model.DaemonId(id));
                    });
                }
                if (None$.MODULE$.equals(option)) {
                    return Task$.MODULE$.none();
                }
                throw new MatchError((Object)option);
            });
        }
        return Task$.MODULE$.none();
    }

    private Task<BoxedUnit> startDaemonByAction(DaemonEvent.Start evt) {
        return this.debugT("startDaemonByAction " + new Model.DaemonId(evt.id())).$greater$greater(() -> DaemonExecutor$.startDaemonByAction$$anonfun$1(evt));
    }

    private Task<BoxedUnit> startReclaimedDaemon(String id) {
        return this.debugT("startReclaimedDaemon " + new Model.DaemonId(id)).$greater$greater(() -> this.startReclaimedDaemon$$anonfun$1(id));
    }

    private Task<BoxedUnit> startNonPreferredDaemon(String id) {
        return DaemonManager$.MODULE$.getDaemon(id).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return this.errorT(msg.msg());
            }
            if (either instanceof Right) {
                Model.Daemon daemon = (Model.Daemon)((Right)either).value();
                String string = daemon.preferred();
                String string2 = DaemonConfig$.MODULE$.systemId();
                if (!(string == null ? string2 != null : !string.equals(string2)) || daemon.isRunning()) {
                    return Task$.MODULE$.unit();
                }
                return this.startDaemon(daemon, this.startDaemon$default$2());
            }
            throw new MatchError((Object)either);
        });
    }

    private Task<BoxedUnit> startAutoplayDaemon(Model.Daemon daemon) {
        return new DaemonRunner(daemon, DaemonRunner$.MODULE$.$lessinit$greater$default$2()).run(DaemonRunner$Autoplay$.MODULE$);
    }

    private Task<BoxedUnit> startDaemon(Model.Daemon daemon, String uuid) {
        return new DaemonRunner(daemon, uuid).run(DaemonRunner$Start$.MODULE$);
    }

    private String startDaemon$default$2() {
        return "";
    }

    public Task<BoxedUnit> stopAllDaemons() {
        return DaemonUtil$.MODULE$.stopAllDaemons(this.getCurrentDaemonsIds()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                MODULE$.error(lm.msg());
                return;
            }
            if (either instanceof Right) {
                return;
            }
            throw new MatchError((Object)either);
        }).map((Function1)(JProcedure1 & Serializable)_$7 -> MODULE$.getCurrentDaemonsIds().foreach((Function1 & Serializable)_$8 -> DaemonExecutor$.currentDaemons.remove((Object)new Model.DaemonId(_$8 == null ? null : ((Model.DaemonId)_$8).value()))));
    }

    public boolean canRunDaemons() {
        return !lifecycleRestartRequested.get();
    }

    public Set<Model.DaemonId> getCurrentDaemonsIds() {
        return currentDaemons.keySet().toSet();
    }

    public void addCurrentDaemom(String id, DaemonRunner runner) {
        currentDaemons.put((Object)new Model.DaemonId(id), (Object)runner);
    }

    public Task<BoxedUnit> handleRunningDaemonEvent(String id) {
        if (currentDaemons.keySet().contains((Object)new Model.DaemonId(id))) {
            return DaemonEvent$.MODULE$.fireRunningDaemonConfirmedEvent(id);
        }
        return Task$.MODULE$.unit();
    }

    public void removeCurrentDaemom(String id) {
        currentDaemons.remove((Object)new Model.DaemonId(id)).foreach((Function1)(JProcedure1 & Serializable)_$9 -> _$9.destroy());
    }

    public Task<BoxedUnit> removeCurrentDaemom2(String id) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            DaemonExecutor$.removeCurrentDaemom2$$anonfun$1(id);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean lifecycleRestartRequest$$anonfun$1$$anonfun$1() {
        return lifecycleRestartRequested.getAndSet(true);
    }

    private static final /* synthetic */ Task lifecycleRestartRequest$$anonfun$1$$anonfun$2(boolean isRestart) {
        return MODULE$.fireLifecycleRestartEvent(isRestart).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.lifecycleRestartStopAll().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.infoT("Lifecycle Restart completed").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    private static final Task lifecycleRestartStopAll$$anonfun$1() {
        return new StopAllAction(MODULE$.getCurrentDaemonsIds(), false).run().map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                MODULE$.error(lm.msg());
                return;
            }
            if (either instanceof Right) {
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    private static final /* synthetic */ Task startPreferredDaemons$$anonfun$1$$anonfun$1(boolean hasToRun) {
        MODULE$.debug("Runnable Daemons found:" + hasToRun);
        if (hasToRun) {
            return DaemonManager$.MODULE$.getPreferredAutoplayDaemons(MODULE$.getCurrentDaemonsIds()).flatMap((Function1 & Serializable)list -> {
                String idsStr = list.isEmpty() ? "" : list.map((Function1 & Serializable)_$5 -> _$5._id()).mkString("[", ",", "]");
                MODULE$.info("(" + list.size() + ") Preferred Daemons Started. " + idsStr);
                List tasks = list.map((Function1 & Serializable)daemon -> MODULE$.startAutoplayDaemon((Model.Daemon)daemon));
                AuditHelper$.MODULE$.send(true, "DaemonExecutor", "Started (" + list.size() + ") Preferred Daemons", (Option<String>)Some$.MODULE$.apply((Object)idsStr));
                return Task$.MODULE$.parSequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()).void();
            });
        }
        return Task$.MODULE$.unit();
    }

    private static final Task startPreferredDaemons$$anonfun$1(boolean isStartup$1) {
        return DaemonManager$.MODULE$.takePreferredDaemons(MODULE$.getCurrentDaemonsIds(), isStartup$1).flatMap((Function1 & Serializable)hasToRun -> DaemonExecutor$.startPreferredDaemons$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)hasToRun)));
    }

    private static final Task startDaemonByAction$$anonfun$1(DaemonEvent.Start evt$1) {
        return DaemonManager$.MODULE$.getDaemon(evt$1.id()).flatMap((Function1 & Serializable)x$12 -> {
            Either either = x$12;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return MODULE$.errorT(msg.msg());
            }
            if (either instanceof Right) {
                Model.Daemon daemon = (Model.Daemon)((Right)either).value();
                MODULE$.info("daemon: " + daemon + " " + MODULE$.getCurrentDaemonsIds());
                if (daemon.isStarting()) {
                    if (daemon.autoplay()) {
                        return DaemonManager$.MODULE$.takePreferredDaemon(evt$1.id(), false, MODULE$.getCurrentDaemonsIds()).flatMap((Function1 & Serializable)x$1 -> {
                            Option option = x$1;
                            if (option instanceof Some) {
                                MODULE$.info("Started Preferred Daemon " + evt$1.id() + " by Start Action");
                                AuditHelper$.MODULE$.send(true, "DaemonExecutor", "Started Preferred Daemon from Start Action", (Option<String>)Some$.MODULE$.apply((Object)evt$1.id()));
                                return MODULE$.startDaemon(daemon, evt$1.uuid());
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Task$.MODULE$.unit();
                            }
                            throw new MatchError((Object)option);
                        });
                    }
                    String string = evt$1.systemId();
                    String string2 = DaemonConfig$.MODULE$.systemId();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return DaemonManager$.MODULE$.takeStartedDaemon(evt$1.id(), MODULE$.getCurrentDaemonsIds()).flatMap((Function1 & Serializable)x$1 -> {
                            Option option = x$1;
                            if (option instanceof Some) {
                                MODULE$.info("Started Idle Daemon " + evt$1.id() + " by Start Action");
                                AuditHelper$.MODULE$.send(true, "DaemonExecutor", "Started Idle Daemon from Start Action", (Option<String>)Some$.MODULE$.apply((Object)evt$1.id()));
                                return MODULE$.startDaemon(daemon, evt$1.uuid());
                            }
                            if (None$.MODULE$.equals(option)) {
                                MODULE$.warn("No Daemon found for Start Action");
                                return Task$.MODULE$.unit();
                            }
                            throw new MatchError((Object)option);
                        });
                    }
                    return Task$.MODULE$.unit();
                }
                return Task$.MODULE$.unit();
            }
            throw new MatchError((Object)either);
        });
    }

    private final Task startReclaimedDaemon$$anonfun$1$$anonfun$1$$anonfun$1(Model.Daemon daemon$3, String id$3) {
        String string = daemon$3.preferred();
        String string2 = DaemonConfig$.MODULE$.systemId();
        if (!(string != null ? !string.equals(string2) : string2 != null) && daemon$3.isReclaiming()) {
            return DaemonManager$.MODULE$.updateStatusIdleForReclaim(id$3).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    LogMessage msg = (LogMessage)((Left)either).value();
                    return this.errorT(msg.msg());
                }
                if (either instanceof Right) {
                    this.info("Started Reclaimed Daemon " + id$3);
                    AuditHelper$.MODULE$.send(true, "DaemonExecutor", "Started Reclaimed Daemon", (Option<String>)Some$.MODULE$.apply((Object)id$3));
                    return this.startDaemon(daemon$3, this.startDaemon$default$2());
                }
                throw new MatchError((Object)either);
            });
        }
        return Task$.MODULE$.unit();
    }

    private final Task startReclaimedDaemon$$anonfun$1(String id$2) {
        return DaemonManager$.MODULE$.getDaemon(id$2).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return this.errorT(msg.msg());
            }
            if (either instanceof Right) {
                Model.Daemon daemon = (Model.Daemon)((Right)either).value();
                return this.debugT("startReclaimedDaemon " + daemon).$greater$greater(() -> this.startReclaimedDaemon$$anonfun$1$$anonfun$1$$anonfun$1(daemon, id$2));
            }
            throw new MatchError((Object)either);
        });
    }

    private static final void removeCurrentDaemom2$$anonfun$1(String id$6) {
        currentDaemons.remove((Object)new Model.DaemonId(id$6));
    }
}

