/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.daemon;

import ambience.SystemScheduler$;
import ambience.api.ChainRunner;
import ambience.api.Notifications;
import ambience.arch.EitherTELM$;
import ambience.arch.package$;
import ambience.etl.daemon.AuditHelper$;
import ambience.etl.daemon.DaemonEvent;
import ambience.etl.daemon.DaemonEvent$;
import ambience.etl.daemon.DaemonEvent$Failed$;
import ambience.etl.daemon.DaemonEvent$KillCompleted$;
import ambience.etl.daemon.DaemonEvent$Reclaim$;
import ambience.etl.daemon.DaemonEvent$RestartCompleted$;
import ambience.etl.daemon.DaemonEvent$StartCompleted$;
import ambience.etl.daemon.DaemonEvent$StopCompleted$;
import ambience.etl.daemon.DaemonExecutor$;
import ambience.etl.daemon.DaemonLogger;
import ambience.etl.daemon.DaemonLoop$;
import ambience.etl.daemon.DaemonManager$;
import ambience.etl.daemon.DaemonRunner$;
import ambience.etl.daemon.DaemonRunner$Autoplay$;
import ambience.etl.daemon.DaemonRunner$Restart$;
import ambience.etl.daemon.DaemonRunner$Retry$;
import ambience.etl.daemon.DaemonRunner$Start$;
import ambience.etl.daemon.Model;
import ambience.etl.daemon.NotifyHelper$;
import ambience.etl.daemon.ReclaimException;
import ambience.etl.daemon.RestartException;
import ambience.etl.daemon.StopException;
import ambience.etl.daemon.UserHelper$;
import ambience.framework.EventBus;
import ambience.framework.EventBus$;
import ambience.module.UserDB;
import cats.effect.ExitCase;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler$;
import monix.reactive.Observable$;
import org.bson.BsonBoolean;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class DaemonRunner
implements LoggingHelper2,
DaemonLogger {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DaemonRunner.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DaemonRunner.class.getDeclaredField("chainRunner$lzy1"));
    private volatile Object log$lzy1;
    private final Model.Daemon daemon;
    private final String startUUID;
    private final String id;
    private volatile Object chainRunner$lzy1;
    private Option<CancelableFuture<BoxedUnit>> cancelable;
    private String stopUUID;
    private String restartUUID;
    private final CancelableFuture watcher;

    public static String $lessinit$greater$default$2() {
        return DaemonRunner$.MODULE$.$lessinit$greater$default$2();
    }

    public DaemonRunner(Model.Daemon daemon, String startUUID) {
        this.daemon = daemon;
        this.startUUID = startUUID;
        this.id = Model.DaemonId$.MODULE$.apply(daemon);
        this.cancelable = None$.MODULE$;
        DaemonExecutor$.MODULE$.addCurrentDaemom(this.id(), this);
        this.watcher = EventBus$.MODULE$.events((Function1 & Serializable)msg -> DaemonLoop$.MODULE$.filterNow((EventBus.Message)msg), 100).mapEval((Function1 & Serializable)msg -> this.eventBusUpdate(DaemonEvent$.MODULE$.extractEvent(msg.eventType()), msg.doc())).completedL().runToFuture(Scheduler$.MODULE$.global());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    private ChainRunner chainRunner() {
        Object object = this.chainRunner$lzy1;
        if (object instanceof ChainRunner) {
            return (ChainRunner)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ChainRunner)this.chainRunner$lzyINIT1();
    }

    private Object chainRunner$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.chainRunner$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ChainRunner chainRunner = null;
                    try {
                        chainRunner = (ChainRunner)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ChainRunner.class));
                        object2 = chainRunner == null ? LazyVals.NullValue$.MODULE$ : chainRunner;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.chainRunner$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return chainRunner;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CancelableFuture<BoxedUnit> watcher() {
        return this.watcher;
    }

    public Task<BoxedUnit> eventBusUpdate(DaemonEvent eventType, Document doc) {
        DaemonEvent daemonEvent = eventType;
        if (daemonEvent instanceof DaemonEvent.Kill) {
            DaemonEvent.Kill e = (DaemonEvent.Kill)daemonEvent;
            String string = e.id();
            String string2 = this.id();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.handleKill(e);
            }
        }
        if (daemonEvent instanceof DaemonEvent.Stop) {
            DaemonEvent.Stop e = (DaemonEvent.Stop)daemonEvent;
            String string = e.id();
            String string3 = this.id();
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return this.stopDaemon(e, doc);
            }
        }
        if (daemonEvent instanceof DaemonEvent.Restart) {
            DaemonEvent.Restart e = (DaemonEvent.Restart)daemonEvent;
            String string = e.id();
            String string4 = this.id();
            if (!(string != null ? !string.equals(string4) : string4 != null)) {
                return this.restartDaemon(e);
            }
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> handleKill(DaemonEvent.Kill evt) {
        return DaemonManager$.MODULE$.updateAutoplay(this.id(), false).$greater$greater(() -> this.handleKill$$anonfun$1(evt));
    }

    public Task<BoxedUnit> run(RunMode mode) {
        Option<CancelableFuture<BoxedUnit>> oldCancelable = this.cancelable;
        return DaemonExecutor$.MODULE$.isDaemonRunner().map((Function1 & Serializable)v1 -> {
            this.run$$anonfun$1(mode, oldCancelable, BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        });
    }

    public CancelableFuture<Either<LogMessage, BoxedUnit>> doRun(RunMode mode) {
        return EitherTELM$.MODULE$.apply(UserHelper$.MODULE$.getUser().map((Function1 & Serializable)_$4 -> _$4.toRight(DaemonRunner::doRun$$anonfun$1$$anonfun$1))).flatMap((Function1 & Serializable)user -> EitherTELM$.MODULE$.apply(DaemonManager$.MODULE$.updateStatusRunning(this.id())).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            RunMode runMode = mode;
            return (DaemonRunner$Retry$.MODULE$.equals(runMode) ? EitherTELM$.MODULE$.apply(package$.MODULE$.TRUnit()) : EitherTELM$.MODULE$.apply(DaemonManager$.MODULE$.resetRetries(this.id(), false))).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherTELM$.MODULE$.apply(this.fireRunCompleteEvent(mode)).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherTELM$.MODULE$.apply(this.runDaemon((UserDB.User)user)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                });
            });
        })).value().runToFuture(SystemScheduler$.MODULE$.global());
    }

    public Task<Either<LogMessage, BoxedUnit>> fireRunCompleteEvent(RunMode mode) {
        return this.debugT("fireRunCompleteEvent called").flatMap((Function1 & Serializable)_$5 -> {
            RunMode runMode = mode;
            if (DaemonRunner$Autoplay$.MODULE$.equals(runMode)) {
                return package$.MODULE$.TRUnit();
            }
            if (DaemonRunner$Start$.MODULE$.equals(runMode)) {
                return DaemonEvent$.MODULE$.fireEvent(DaemonEvent$StartCompleted$.MODULE$.apply(this.id(), this.startUUID), DaemonEvent$.MODULE$.fireEvent$default$2()).map((Function1 & Serializable)_$6 -> package$.MODULE$.RUnit());
            }
            if (DaemonRunner$Retry$.MODULE$.equals(runMode)) {
                return package$.MODULE$.TRUnit();
            }
            if (DaemonRunner$Restart$.MODULE$.equals(runMode)) {
                return DaemonEvent$.MODULE$.fireEvent(DaemonEvent$RestartCompleted$.MODULE$.apply(this.id(), this.restartUUID), DaemonEvent$.MODULE$.fireEvent$default$2()).map((Function1 & Serializable)_$7 -> package$.MODULE$.RUnit());
            }
            throw new MatchError((Object)runMode);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> runDaemon(UserDB.User user) {
        ChainRunner.ChainIdSpec spec = ChainRunner.ChainIdSpec$.MODULE$.apply(this.daemon.job().chainset(), this.daemon.job().chain());
        return this.debugT("ETL Spec:" + spec).flatMap((Function1 & Serializable)_$8 -> this.chainRunner().runChain(user, (ChainRunner.ChainSpec)spec, Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{org.mongodb.scala.bson.package$.MODULE$.Document().apply(this.buildInitJSON().noSpaces())}))).completedL().onErrorRecoverWith((PartialFunction)new Serializable(this){
            private final /* synthetic */ DaemonRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof StopException) {
                    StopException ex = (StopException)throwable;
                    return true;
                }
                if (throwable instanceof RestartException) {
                    RestartException ex = (RestartException)throwable;
                    return true;
                }
                if (throwable instanceof ReclaimException) {
                    ReclaimException ex = (ReclaimException)throwable;
                    return true;
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof StopException) {
                    StopException ex = (StopException)throwable;
                    return this.$outer.doStop(ex.id());
                }
                if (throwable instanceof RestartException) {
                    RestartException ex = (RestartException)throwable;
                    return this.$outer.doRestart(ex.id());
                }
                if (throwable instanceof ReclaimException) {
                    ReclaimException ex = (ReclaimException)throwable;
                    return this.$outer.doReclaim(ex.id());
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return this.$outer.doFail(ex);
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$9 -> package$.MODULE$.RUnit()));
    }

    public Task<BoxedUnit> stopDaemon(DaemonEvent.Stop evt, Document doc) {
        this.stopUUID = evt.uuid();
        return DaemonManager$.MODULE$.updateStatusStopping(this.id(), this.isAutoplayOff(doc)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                this.error("stop failed " + lm.msg());
                DaemonEvent$.MODULE$.fireErrorEvent(this.id(), "Stop failed " + lm.msg());
                return;
            }
            if (either instanceof Right) {
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<BoxedUnit> restartDaemon(DaemonEvent.Restart evt) {
        this.restartUUID = evt.uuid();
        return DaemonManager$.MODULE$.updateStatusRestarting(this.id()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                this.error("restart failed " + lm.msg());
                DaemonEvent$.MODULE$.fireErrorEvent(this.id(), "Restart failed " + lm.msg());
                return;
            }
            if (either instanceof Right) {
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<BoxedUnit> doRestart(String dId) {
        if (DaemonExecutor$.MODULE$.canRunDaemons()) {
            String string = this.id();
            String string2 = dId;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.debugT("restarted").flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return AuditHelper$.MODULE$.sendT(true, "DaemonRunner", "Restarted", (Option<String>)Some$.MODULE$.apply((Object)this.id())).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.removeCurrentDaemon2T().flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.run(DaemonRunner$Restart$.MODULE$).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            });
                        });
                    });
                });
            }
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> doStop(String dId) {
        String string = this.id();
        String string2 = dId;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.debugT("stop").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return AuditHelper$.MODULE$.sendT(true, "DaemonRunner", "Stopped", (Option<String>)Some$.MODULE$.apply((Object)this.id())).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.removeCurrentDaemonT().flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return DaemonEvent$.MODULE$.fireEvent(DaemonEvent$StopCompleted$.MODULE$.apply(this.id(), this.stopUUID), DaemonEvent$.MODULE$.fireEvent$default$2()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                });
            });
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> doReclaim(String dId) {
        String string = this.id();
        String string2 = dId;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.debugT("reclaim").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return AuditHelper$.MODULE$.sendT(true, "DaemonRunner", "Reclaim", (Option<String>)Some$.MODULE$.apply((Object)this.id())).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.removeCurrentDaemon2T().flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return DaemonEvent$.MODULE$.fireEvent(DaemonEvent$Reclaim$.MODULE$.apply(this.id()), DaemonEvent$.MODULE$.fireEvent$default$2()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                });
            });
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> doFail(Throwable ex) {
        return this.errorT("Failed: " + ex).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return AuditHelper$.MODULE$.sendT(false, "DaemonRunner", "Failed", (Option<String>)Some$.MODULE$.apply((Object)(this.id() + " " + ex))).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return DaemonManager$.MODULE$.updateStatusFailed(this.id(), (String)Option$.MODULE$.apply((Object)ex.getMessage()).getOrElse(DaemonRunner::doFail$$anonfun$1$$anonfun$1$$anonfun$1)).flatMap((Function1 & Serializable)x$12 -> {
                    Either either = x$12;
                    return this.removeCurrentDaemon2T().flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(String.valueOf(ex))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        return DaemonEvent$.MODULE$.fireEvent(DaemonEvent$Failed$.MODULE$.apply(this.id()), org.mongodb.scala.bson.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.tryRetry(ex).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            });
                        });
                    });
                });
            });
        }).guaranteeCase((Function1 & Serializable)x$1 -> {
            ExitCase exitCase = x$1;
            if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                return this.infoT("Completed guarantee");
            }
            if (exitCase instanceof ExitCase.Error) {
                Throwable throwable;
                ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                Throwable e = throwable = (Throwable)error._1();
                return this.infoT("Error guarantee " + e);
            }
            if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                return this.infoT("Canceled guarantee");
            }
            throw new MatchError((Object)exitCase);
        });
    }

    public Task<BoxedUnit> tryRetry(Throwable ex) {
        return DaemonManager$.MODULE$.getDaemon(this.id()).flatMap((Function1 & Serializable)x$13 -> {
            Either either = x$13;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                return this.errorT(lm.msg());
            }
            if (either instanceof Right) {
                Model.Daemon daemon = (Model.Daemon)((Right)either).value();
                int remaining = daemon.retryStrategy().retriesRemaining();
                return (remaining > 0 ? this.infoT("retries remaining (" + remaining + ") sending notification").flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return AuditHelper$.MODULE$.sendT(false, "DaemonRunner", "Failed", (Option<String>)Some$.MODULE$.apply((Object)(this.id() + " (" + remaining + ") retries remaining. " + ex))).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return NotifyHelper$.MODULE$.notify((Notifications.Level)Notifications.Warning$.MODULE$, daemon, "Failed retries remaining (" + remaining + ")", (Option<Throwable>)Some$.MODULE$.apply((Object)ex)).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return DaemonManager$.MODULE$.updateRetries(this.id(), remaining - 1).flatMap((Function1 & Serializable)x$12 -> {
                                Either either = x$12;
                                return this.run(DaemonRunner$Retry$.MODULE$).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                });
                            });
                        });
                    });
                }) : DaemonManager$.MODULE$.updateAutoplay(this.id(), false).flatMap((Function1 & Serializable)x$12 -> {
                    Either either = x$12;
                    return this.infoT("retries 0 sending notification").flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return AuditHelper$.MODULE$.sendT(false, "DaemonRunner", "Failed", (Option<String>)Some$.MODULE$.apply((Object)(this.id() + " no retries remaining. " + ex))).flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return NotifyHelper$.MODULE$.notify((Notifications.Level)Notifications.Error$.MODULE$, daemon, "Failed no retries remaining", (Option<Throwable>)Some$.MODULE$.apply((Object)ex)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            });
                        });
                    });
                })).delayExecution(this.calcRetryDelay(remaining));
            }
            throw new MatchError((Object)either);
        });
    }

    public FiniteDuration calcRetryDelay(int retry) {
        int n = retry;
        int secs = switch (n) {
            case 1 -> 30;
            case 2 -> 20;
            case 3 -> 10;
            default -> 0;
        };
        return FiniteDuration$.MODULE$.apply(Int$.MODULE$.int2long(secs), scala.concurrent.duration.package$.MODULE$.SECONDS());
    }

    public Json buildInitJSON() {
        Json json;
        String pms = this.daemon.job().parameters().trim().isEmpty() ? "{}" : this.daemon.job().parameters().trim();
        Either either = io.circe.parser.package$.MODULE$.parse(pms);
        if (either instanceof Left) {
            ParsingFailure msg = (ParsingFailure)((Left)either).value();
            this.error(msg.getMessage());
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"elx-daemonId");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(this.id()));
            json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else if (either instanceof Right) {
            Json json2 = (Json)((Right)either).value();
            json = json2.mapObject((Function1 & Serializable)_$10 -> _$10.add("elx-daemonId", Json$.MODULE$.fromString(this.id())));
        } else {
            throw new MatchError((Object)either);
        }
        Json json3 = json;
        this.debug("initial json:" + json3);
        return json3;
    }

    public Task<BoxedUnit> removeCurrentDaemonT() {
        DaemonExecutor$.MODULE$.removeCurrentDaemom(this.id());
        return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
    }

    public Task<BoxedUnit> removeCurrentDaemon2T() {
        return DaemonExecutor$.MODULE$.removeCurrentDaemom2(this.id());
    }

    public void cancel() {
        this.cancelable.foreach((Function1)(JProcedure1 & Serializable)_$11 -> _$11.cancel());
    }

    public Task<BoxedUnit> cancelT() {
        this.cancel();
        return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
    }

    public boolean isAutoplayOff(Document doc) {
        return BoxesRunTime.unboxToBoolean((Object)doc.get("autoplayOff", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).map((Function1 & Serializable)_$12 -> _$12.getValue()).getOrElse(DaemonRunner::isAutoplayOff$$anonfun$2));
    }

    public void destroy() {
        this.watcher().cancel();
        this.cancel();
    }

    private final void handleKill$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1() {
        DaemonExecutor$.MODULE$.removeCurrentDaemom(this.id());
    }

    private final Task handleKill$$anonfun$1(DaemonEvent.Kill evt$1) {
        return DaemonManager$.MODULE$.updateStatusIdle(this.id()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return this.errorT("Kill failed " + msg.msg()).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return DaemonEvent$.MODULE$.fireErrorEventT(this.id(), "Kill failed " + msg.msg()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                });
            }
            if (either instanceof Right) {
                return this.infoT("Kill called " + new Model.DaemonId(this.id())).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.cancelT().flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                            this.handleKill$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1();
                            return BoxedUnit.UNIT;
                        }).flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return DaemonEvent$.MODULE$.fireEvent(DaemonEvent$KillCompleted$.MODULE$.apply(this.id(), evt$1.uuid()), DaemonEvent$.MODULE$.fireEvent$default$2()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            });
                        });
                    });
                });
            }
            throw new MatchError((Object)either);
        });
    }

    private final /* synthetic */ void run$$anonfun$1(RunMode mode$1, Option oldCancelable$1, boolean canRun) {
        if (canRun && DaemonExecutor$.MODULE$.canRunDaemons()) {
            this.cancelable = Some$.MODULE$.apply((Object)this.doRun(mode$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    LogMessage lm = (LogMessage)((Left)either).value();
                    DaemonEvent$.MODULE$.fireErrorEvent(this.id(), "Start failed " + lm.msg());
                    return;
                }
                if (either instanceof Right) {
                    return;
                }
                throw new MatchError((Object)either);
            }, (ExecutionContext)SystemScheduler$.MODULE$.global()).recover((PartialFunction)new Serializable(this){
                private final /* synthetic */ DaemonRunner $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable ex = throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable ex = throwable;
                        this.$outer.error(ex.getMessage());
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }
            }, (ExecutionContext)SystemScheduler$.MODULE$.global()));
            oldCancelable$1.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.cancel());
            return;
        }
    }

    private static final LogMessage.Error doRun$$anonfun$1$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("No Daemon user found");
    }

    private static final String doFail$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "Unknown Error";
    }

    private static final boolean isAutoplayOff$$anonfun$2() {
        return false;
    }

    public static interface RunMode {
    }
}

