/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderBufferedImageType;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class PngEncoderBufferedImageConverter {
    private static final int[] BAND_MASKS_INT_ARGB = new int[]{0xFF0000, 65280, 255, -16777216};
    private static final ColorModel COLOR_MODEL_INT_ARGB = ColorModel.getRGBdefault();
    private static final int[] BAND_MASKS_INT_RGB = new int[]{0xFF0000, 65280, 255};
    private static final ColorModel COLOR_MODEL_INT_RGB = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final int[] BAND_MASKS_INT_ARGB_PRE = new int[]{0xFF0000, 65280, 255, -16777216};
    private static final ColorModel COLOR_MODEL_INT_ARGB_PRE = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    private static final int[] BAND_MASKS_INT_BGR = new int[]{255, 65280, 0xFF0000};
    private static final ColorModel COLOR_MODEL_INT_BGR = new DirectColorModel(24, 255, 65280, 0xFF0000);
    private static final int[] BAND_MASKS_USHORT_565_RGB = new int[]{63488, 2016, 31};
    private static final int[] BAND_MASKS_USHORT_555_RGB = new int[]{31744, 992, 31};

    private PngEncoderBufferedImageConverter() {
    }

    public static BufferedImage createFromIntArgb(int[] data, int width, int height) {
        DataBufferInt dataBuffer = new DataBufferInt(data, data.length);
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, width, height, width, BAND_MASKS_INT_ARGB, null);
        return new BufferedImage(COLOR_MODEL_INT_ARGB, raster, false, null);
    }

    public static BufferedImage createFromIntRgb(int[] data, int width, int height) {
        DataBufferInt dataBuffer = new DataBufferInt(data, data.length);
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, width, height, width, BAND_MASKS_INT_RGB, null);
        return new BufferedImage(COLOR_MODEL_INT_RGB, raster, false, null);
    }

    public static BufferedImage createFromIntArgbPre(int[] data, int width, int height) {
        DataBufferInt dataBuffer = new DataBufferInt(data, data.length);
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, width, height, width, BAND_MASKS_INT_ARGB_PRE, null);
        return new BufferedImage(COLOR_MODEL_INT_ARGB_PRE, raster, true, null);
    }

    public static BufferedImage createFromIntBgr(int[] data, int width, int height) {
        DataBufferInt dataBuffer = new DataBufferInt(data, data.length);
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, width, height, width, BAND_MASKS_INT_BGR, null);
        return new BufferedImage(COLOR_MODEL_INT_BGR, raster, false, null);
    }

    public static BufferedImage createFrom3ByteBgr(byte[] data, int width, int height) {
        DataBufferByte dataBuffer = new DataBufferByte(data, data.length);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8};
        int[] bOffs = new int[]{2, 1, 0};
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, nBits, false, false, 1, 0);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, width, height, width * 3, 3, bOffs, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage createFrom4ByteAbgr(byte[] data, int width, int height) {
        DataBufferByte dataBuffer = new DataBufferByte(data, data.length);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        int[] bOffs = new int[]{3, 2, 1, 0};
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, nBits, true, false, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, width, height, width * 4, 4, bOffs, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage createFrom4ByteAbgrPre(byte[] data, int width, int height) {
        DataBufferByte dataBuffer = new DataBufferByte(data, data.length);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        int[] bOffs = new int[]{3, 2, 1, 0};
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, nBits, true, true, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, width, height, width * 4, 4, bOffs, null);
        return new BufferedImage(colorModel, raster, true, null);
    }

    public static BufferedImage createFromUshort565Rgb(short[] data, int width, int height) {
        DataBufferUShort dataBuffer = new DataBufferUShort(data, data.length);
        DirectColorModel colorModel = new DirectColorModel(16, BAND_MASKS_USHORT_565_RGB[0], BAND_MASKS_USHORT_565_RGB[1], BAND_MASKS_USHORT_565_RGB[2]);
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, width, height, width, BAND_MASKS_USHORT_565_RGB, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage createFromUshort555Rgb(short[] data, int width, int height) {
        DataBufferUShort dataBuffer = new DataBufferUShort(data, data.length);
        DirectColorModel colorModel = new DirectColorModel(15, BAND_MASKS_USHORT_555_RGB[0], BAND_MASKS_USHORT_555_RGB[1], BAND_MASKS_USHORT_555_RGB[2]);
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, width, height, width, BAND_MASKS_USHORT_555_RGB, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage createFromByteGray(byte[] data, int width, int height) {
        DataBufferByte dataBuffer = new DataBufferByte(data, data.length);
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nBits = new int[]{8};
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, nBits, false, true, 1, 0);
        int[] bandOffsets = new int[]{0};
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, width, height, width, 1, bandOffsets, null);
        return new BufferedImage(colorModel, raster, true, null);
    }

    public static BufferedImage createFromUshortGray(short[] data, int width, int height) {
        DataBufferUShort dataBuffer = new DataBufferUShort(data, data.length);
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nBits = new int[]{16};
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, nBits, false, false, 1, 1);
        int[] bandOffsets = new int[]{0};
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, width, height, width, 1, bandOffsets, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage createFromByteBinary(byte[] data, int width, int height) {
        DataBufferByte dataBuffer = new DataBufferByte(data, data.length);
        byte[] arr = new byte[]{0, -1};
        IndexColorModel colorModel = new IndexColorModel(1, 2, arr, arr, arr);
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, width, height, 1, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static DataBuffer getDataBuffer(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getDataBuffer();
    }

    public static DataBufferInt getDataBufferInt(BufferedImage bufferedImage) {
        return (DataBufferInt)PngEncoderBufferedImageConverter.getDataBuffer(bufferedImage);
    }

    public static DataBufferUShort getDataBufferUShort(BufferedImage bufferedImage) {
        return (DataBufferUShort)PngEncoderBufferedImageConverter.getDataBuffer(bufferedImage);
    }

    public static DataBufferByte getDataBufferByte(BufferedImage bufferedImage) {
        return (DataBufferByte)PngEncoderBufferedImageConverter.getDataBuffer(bufferedImage);
    }

    public static BufferedImage copyType(BufferedImage bufferedImage, PngEncoderBufferedImageType type) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        BufferedImage convertedBufferedImage = new BufferedImage(width, height, type.ordinal());
        Graphics graphics = convertedBufferedImage.getGraphics();
        if (convertedBufferedImage.getTransparency() == 1) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, width, height);
        }
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return convertedBufferedImage;
    }

    public static BufferedImage ensureType(BufferedImage bufferedImage, PngEncoderBufferedImageType type) {
        if (PngEncoderBufferedImageType.valueOf(bufferedImage) == type) {
            return bufferedImage;
        }
        return PngEncoderBufferedImageConverter.copyType(bufferedImage, type);
    }
}

