/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderDeflaterBuffer;
import java.util.Objects;

class PngEncoderDeflaterSegmentResult {
    private final PngEncoderDeflaterBuffer originalSegment;
    private final PngEncoderDeflaterBuffer deflatedSegment;
    private final long originalSegmentAdler32;
    private final int originalSegmentLength;

    PngEncoderDeflaterSegmentResult(PngEncoderDeflaterBuffer originalSegment, PngEncoderDeflaterBuffer deflatedSegment, long originalSegmentAdler32, int originalSegmentLength) {
        this.originalSegment = Objects.requireNonNull(originalSegment, "originalSegment");
        this.deflatedSegment = Objects.requireNonNull(deflatedSegment, "deflatedSegment");
        this.originalSegmentAdler32 = originalSegmentAdler32;
        this.originalSegmentLength = originalSegmentLength;
    }

    public PngEncoderDeflaterBuffer getOriginalSegment() {
        return this.originalSegment;
    }

    public PngEncoderDeflaterBuffer getDeflatedSegment() {
        return this.deflatedSegment;
    }

    long getUpdatedAdler32(long originalAdler32) {
        return PngEncoderDeflaterSegmentResult.combine(originalAdler32, this.originalSegmentAdler32, this.originalSegmentLength);
    }

    static long combine(long adler1, long adler2, long len2) {
        long BASEL = 65521L;
        long rem = len2 % BASEL;
        long sum1 = adler1 & 0xFFFFL;
        long sum2 = rem * sum1;
        sum2 %= BASEL;
        sum2 += (adler1 >> 16 & 0xFFFFL) + (adler2 >> 16 & 0xFFFFL) + BASEL - rem;
        if ((sum1 += (adler2 & 0xFFFFL) + BASEL - 1L) >= BASEL) {
            sum1 -= BASEL;
        }
        if (sum1 >= BASEL) {
            sum1 -= BASEL;
        }
        if (sum2 >= BASEL << 1) {
            sum2 -= BASEL << 1;
        }
        if (sum2 >= BASEL) {
            sum2 -= BASEL;
        }
        return sum1 | sum2 << 16;
    }
}

