/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderScanlineUtil;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PngEncoderIndexed {
    static IndexedEncoderResult encodeImage(BufferedImage image, PngEncoderScanlineUtil.EncodingMetaInfo metaInfo) throws IOException {
        if (metaInfo.bitsPerChannel != 8 || metaInfo.channels == 1) {
            return null;
        }
        final ByteArrayOutputStream out = new ByteArrayOutputStream(image.getHeight() * (image.getWidth() + 1));
        final byte[] indexedRow = new byte[image.getWidth() + 1];
        final ColorTable table = new ColorTable();
        try {
            if (metaInfo.hasAlpha) {
                PngEncoderScanlineUtil.stream(image, 0, image.getHeight(), new PngEncoderScanlineUtil.AbstractPNGLineConsumer(){
                    boolean firstRow = true;

                    @Override
                    void consume(byte[] currRow, byte[] prevRow) throws IOException {
                        if (this.firstRow) {
                            int r = currRow[1] & 0xFF;
                            int g = currRow[2] & 0xFF;
                            int b = currRow[3] & 0xFF;
                            int a = currRow[4] & 0xFF;
                            int v = a << 24 | r << 16 | g << 8 | b;
                            if (a == 0) {
                                v = 0;
                            }
                            table.findColorLookup(v);
                            this.firstRow = false;
                        }
                        int readPtr = 1;
                        for (int x = 1; x < indexedRow.length; ++x) {
                            int a;
                            int r = currRow[readPtr++] & 0xFF;
                            int g = currRow[readPtr++] & 0xFF;
                            int b = currRow[readPtr++] & 0xFF;
                            int v = (a = currRow[readPtr++] & 0xFF) == 0 ? 0 : a << 24 | r << 16 | g << 8 | b;
                            indexedRow[x] = table.findColor(v);
                        }
                        out.write(indexedRow);
                    }
                });
            } else {
                PngEncoderScanlineUtil.stream(image, 0, image.getHeight(), new PngEncoderScanlineUtil.AbstractPNGLineConsumer(){
                    boolean firstRow = true;

                    @Override
                    void consume(byte[] currRow, byte[] prevRow) throws IOException {
                        if (this.firstRow) {
                            int r = currRow[1] & 0xFF;
                            int g = currRow[2] & 0xFF;
                            int b = currRow[3] & 0xFF;
                            int v = 0xFF000000 | r << 16 | g << 8 | b;
                            table.findColorLookup(v);
                            this.firstRow = false;
                        }
                        int readPtr = 1;
                        for (int x = 1; x < indexedRow.length; ++x) {
                            int r = currRow[readPtr++] & 0xFF;
                            int g = currRow[readPtr++] & 0xFF;
                            int b = currRow[readPtr++] & 0xFF;
                            int v = 0xFF000000 | r << 16 | g << 8 | b;
                            indexedRow[x] = table.findColor(v);
                        }
                        out.write(indexedRow);
                    }
                });
            }
        }
        catch (IndexOutOfBoundsException ignored) {
            return null;
        }
        return PngEncoderIndexed.makeIndexedEncoderResult(metaInfo, out, indexedRow.length, table);
    }

    private static IndexedEncoderResult makeIndexedEncoderResult(PngEncoderScanlineUtil.EncodingMetaInfo metaInfo, ByteArrayOutputStream out, int rowByteSize, ColorTable table) {
        IndexedEncoderResult result = new IndexedEncoderResult();
        result.rawIDAT = out.toByteArray();
        result.colorTable = table.makeColorTable();
        if (metaInfo.hasAlpha) {
            result.transparencyTable = table.makeTransparencyTable();
        }
        metaInfo.colorSpaceType = PngEncoderScanlineUtil.EncodingMetaInfo.ColorSpaceType.Indexed;
        metaInfo.rowByteSize = rowByteSize;
        return result;
    }

    static IndexedEncoderResult encodeImageFromIndexed(BufferedImage image, PngEncoderScanlineUtil.EncodingMetaInfo metaInfo) {
        assert (image.getType() == 13);
        IndexColorModel colorModel = (IndexColorModel)image.getColorModel();
        assert (colorModel.hasAlpha() == metaInfo.hasAlpha);
        int colorCount = colorModel.getMapSize();
        if (colorCount > 256) {
            return null;
        }
        Raster imageRaster = image.getData();
        DataBuffer dataBuffer = imageRaster.getDataBuffer();
        if (!(dataBuffer instanceof DataBufferByte)) {
            return null;
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        if (!(imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel)) {
            return null;
        }
        int width = image.getWidth();
        ByteArrayOutputStream out = new ByteArrayOutputStream(image.getHeight() * width);
        PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
        byte[] rawBytes = dataBufferByte.getData();
        int scanlineStride = sampleModel.getScanlineStride();
        int pixelStride = sampleModel.getPixelStride();
        assert (pixelStride == 1);
        int yStart = 0;
        int heightToStream = image.getHeight();
        int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
        for (int y = 0; y < heightToStream; ++y) {
            int pixelPtr = linePtr;
            out.write(0);
            out.write(rawBytes, pixelPtr, width);
            linePtr += scanlineStride;
        }
        ColorTable table = new ColorTable();
        table.copyFromIndexedColorModel(colorModel);
        return PngEncoderIndexed.makeIndexedEncoderResult(metaInfo, out, width + 1, table);
    }

    private static class ColorTable {
        int[] colorTable = new int[256];
        int usedColors = 0;
        int lastColor;
        int lastColorIndex = 0;

        private ColorTable() {
        }

        byte findColor(int color) {
            if (this.lastColor == color) {
                return (byte)this.lastColorIndex;
            }
            return (byte)this.findColorLookup(color);
        }

        private int findColorLookup(int color) {
            for (int i = 0; i < this.usedColors; ++i) {
                if (this.colorTable[i] != color) continue;
                this.lastColor = color;
                this.lastColorIndex = i;
                return i;
            }
            int colorIndex = this.usedColors++;
            this.colorTable[colorIndex] = color;
            this.lastColor = color;
            this.lastColorIndex = colorIndex;
            return colorIndex;
        }

        public byte[] makeColorTable() {
            byte[] res = new byte[3 * this.usedColors];
            int dest = 0;
            for (int i = 0; i < this.usedColors; ++i) {
                int color = this.colorTable[i];
                res[dest++] = (byte)((color & 0xFF0000) >> 16);
                res[dest++] = (byte)((color & 0xFF00) >> 8);
                res[dest++] = (byte)(color & 0xFF);
            }
            return res;
        }

        public byte[] makeTransparencyTable() {
            byte[] res = new byte[this.usedColors];
            int dest = 0;
            for (int i = 0; i < this.usedColors; ++i) {
                int color = this.colorTable[i];
                res[dest++] = (byte)((color & 0xFF000000) >> 24);
            }
            return res;
        }

        public void copyFromIndexedColorModel(IndexColorModel colorModel) {
            this.usedColors = colorModel.getMapSize();
            assert (this.usedColors <= 256);
            colorModel.getRGBs(this.colorTable);
        }
    }

    static class IndexedEncoderResult {
        byte[] colorTable;
        byte[] transparencyTable;
        byte[] rawIDAT;

        IndexedEncoderResult() {
        }
    }
}

