/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderScanlineUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class PngEncoderPredictor {
    private byte[] dataRawRowSub;
    private byte[] dataRawRowUp;
    private byte[] dataRawRowAverage;
    private byte[] dataRawRowPaeth;

    private PngEncoderPredictor() {
    }

    static void encodeImageMultiThreaded(BufferedImage image, PngEncoderScanlineUtil.EncodingMetaInfo metaInfo, OutputStream out) throws IOException {
        int height = image.getHeight();
        int heightPerSlice = Math.max(10, 131072 / metaInfo.rowByteSize) + 1;
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(heightPerSlice * metaInfo.rowByteSize);
        for (int y = 0; y < height; y += heightPerSlice) {
            int heightToProcess = Math.min(heightPerSlice, height - y);
            new PngEncoderPredictor().encodeImage(image, y, heightToProcess, metaInfo, outBytes);
            outBytes.writeTo(out);
            outBytes.reset();
        }
    }

    static void encodeImageSingleThreaded(BufferedImage image, PngEncoderScanlineUtil.EncodingMetaInfo metaInfo, OutputStream outputStream) throws IOException {
        new PngEncoderPredictor().encodeImage(image, 0, image.getHeight(), metaInfo, outputStream);
    }

    private void encodeImage(BufferedImage image, int yStart, int height, final PngEncoderScanlineUtil.EncodingMetaInfo metaInfo, final OutputStream outputStream) throws IOException {
        this.dataRawRowSub = new byte[metaInfo.rowByteSize];
        this.dataRawRowUp = new byte[metaInfo.rowByteSize];
        this.dataRawRowAverage = new byte[metaInfo.rowByteSize];
        this.dataRawRowPaeth = new byte[metaInfo.rowByteSize];
        this.dataRawRowSub[0] = 1;
        this.dataRawRowUp[0] = 2;
        this.dataRawRowAverage[0] = 3;
        this.dataRawRowPaeth[0] = 4;
        final boolean redoFirstRow = yStart > 0;
        PngEncoderScanlineUtil.stream(image, redoFirstRow ? yStart - 1 : yStart, height + (redoFirstRow ? 1 : 0), new PngEncoderScanlineUtil.AbstractPNGLineConsumer(){
            boolean skipFirstRow;
            {
                this.skipFirstRow = redoFirstRow;
            }

            @Override
            void consume(byte[] currRow, byte[] prevRow) throws IOException {
                if (this.skipFirstRow) {
                    this.skipFirstRow = false;
                    return;
                }
                int bpp = metaInfo.bytesPerPixel;
                byte[] dataRawRowNone = currRow;
                byte[] dataRawRowSub = PngEncoderPredictor.this.dataRawRowSub;
                byte[] dataRawRowUp = PngEncoderPredictor.this.dataRawRowUp;
                byte[] dataRawRowAverage = PngEncoderPredictor.this.dataRawRowAverage;
                byte[] dataRawRowPaeth = PngEncoderPredictor.this.dataRawRowPaeth;
                int bLen = currRow.length;
                assert (currRow.length == prevRow.length);
                assert (currRow[0] == 0);
                assert (prevRow[0] == 0);
                long estCompressSum = 0L;
                long estCompressSumSub = 1L;
                long estCompressSumUp = 2L;
                long estCompressSumAvg = 3L;
                long estCompressSumPaeth = 4L;
                int a = 0;
                int c = 0;
                for (int i = 1; i < bLen; ++i) {
                    int x = currRow[i] & 0xFF;
                    int b = prevRow[i] & 0xFF;
                    if (i > bpp) {
                        int prevPixelByte = i - bpp;
                        a = currRow[prevPixelByte] & 0xFF;
                        c = prevRow[prevPixelByte] & 0xFF;
                    }
                    byte bSub = (byte)(x - a);
                    byte bUp = (byte)(x - b);
                    byte bAverage = (byte)(x - (b + a) / 2);
                    int p = a + b - c;
                    int pa = Math.abs(p - a);
                    int pb = Math.abs(p - b);
                    int pc = Math.abs(p - c);
                    int pr = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                    int r = x - pr;
                    byte bPaeth = (byte)r;
                    dataRawRowSub[i] = bSub;
                    dataRawRowUp[i] = bUp;
                    dataRawRowAverage[i] = bAverage;
                    dataRawRowPaeth[i] = bPaeth;
                    estCompressSum += (long)Math.abs(x);
                    estCompressSumSub += (long)Math.abs(bSub);
                    estCompressSumUp += (long)Math.abs(bUp);
                    estCompressSumAvg += (long)Math.abs(bAverage);
                    estCompressSumPaeth += (long)Math.abs(bPaeth);
                }
                byte[] rowToWrite = dataRawRowNone;
                if (estCompressSum > estCompressSumSub) {
                    rowToWrite = dataRawRowSub;
                    estCompressSum = estCompressSumSub;
                }
                if (estCompressSum > estCompressSumUp) {
                    rowToWrite = dataRawRowUp;
                    estCompressSum = estCompressSumUp;
                }
                if (estCompressSum > estCompressSumAvg) {
                    rowToWrite = dataRawRowAverage;
                    estCompressSum = estCompressSumAvg;
                }
                if (estCompressSum > estCompressSumPaeth) {
                    rowToWrite = dataRawRowPaeth;
                }
                outputStream.write(rowToWrite);
            }
        });
    }
}

