/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.api;

import jakarta.json.JsonValue;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.SpecialJsonSchema;

abstract class BooleanJsonSchema
extends SpecialJsonSchema {
    BooleanJsonSchema() {
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public JsonValue.ValueType getJsonValueType() {
        return this.toJson().getValueType();
    }

    static class False
    extends BooleanJsonSchema {
        False() {
        }

        @Override
        public Evaluator createEvaluator(EvaluatorContext context, InstanceType type) {
            return this.alwaysFalse(context);
        }

        @Override
        public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            return Evaluator.ALWAYS_TRUE;
        }

        @Override
        public JsonValue toJson() {
            return JsonValue.FALSE;
        }

        @Override
        public String toString() {
            return "false";
        }
    }

    static class True
    extends BooleanJsonSchema {
        True() {
        }

        @Override
        public Evaluator createEvaluator(EvaluatorContext context, InstanceType type) {
            return Evaluator.ALWAYS_TRUE;
        }

        @Override
        public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            return this.alwaysFalse(context);
        }

        @Override
        public JsonValue toJson() {
            return JsonValue.TRUE;
        }

        @Override
        public String toString() {
            return "true";
        }
    }
}

