/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.api;

import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Objects;
import java.util.stream.Stream;
import org.leadpony.justify.api.BooleanJsonSchema;
import org.leadpony.justify.api.EmptyJsonSchema;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.ObjectJsonSchema;

public interface JsonSchema {
    public static final JsonSchema TRUE = new BooleanJsonSchema.True();
    public static final JsonSchema FALSE = new BooleanJsonSchema.False();
    public static final ObjectJsonSchema EMPTY = new EmptyJsonSchema();

    default public boolean hasId() {
        return false;
    }

    default public boolean hasAbsoluteId() {
        return this.hasId() && this.id().isAbsolute();
    }

    default public URI id() {
        return null;
    }

    default public URI schema() {
        return null;
    }

    default public String comment() {
        return null;
    }

    default public String title() {
        return null;
    }

    default public String description() {
        return null;
    }

    default public JsonValue defaultValue() {
        return null;
    }

    public boolean isBoolean();

    default public ObjectJsonSchema asObjectJsonSchema() {
        return (ObjectJsonSchema)ObjectJsonSchema.class.cast(this);
    }

    default public boolean containsKeyword(String keyword) {
        return false;
    }

    default public JsonValue getKeywordValue(String keyword) {
        return null;
    }

    default public JsonValue getKeywordValue(String keyword, JsonValue defaultValue) {
        return defaultValue;
    }

    default public Stream<JsonSchema> getSubschemas() {
        return Stream.empty();
    }

    default public Stream<JsonSchema> getInPlaceSubschemas() {
        return Stream.empty();
    }

    default public JsonSchema getSubschemaAt(String jsonPointer) {
        Objects.requireNonNull(jsonPointer, "jsonPointer must not be null.");
        return jsonPointer.isEmpty() ? this : null;
    }

    public Evaluator createEvaluator(EvaluatorContext var1, InstanceType var2);

    public Evaluator createNegatedEvaluator(EvaluatorContext var1, InstanceType var2);

    public JsonValue.ValueType getJsonValueType();

    public JsonValue toJson();

    public String toString();

    public static JsonSchema valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }
}

