/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.api;

import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;

public interface JsonSchemaBuilder {
    public JsonSchema build();

    public JsonSchemaBuilder withId(URI var1);

    public JsonSchemaBuilder withSchema(URI var1);

    public JsonSchemaBuilder withComment(String var1);

    public JsonSchemaBuilder withType(InstanceType ... var1);

    public JsonSchemaBuilder withType(Set<InstanceType> var1);

    public JsonSchemaBuilder withEnum(JsonValue ... var1);

    public JsonSchemaBuilder withEnum(Set<JsonValue> var1);

    public JsonSchemaBuilder withConst(JsonValue var1);

    public JsonSchemaBuilder withMultipleOf(long var1);

    public JsonSchemaBuilder withMultipleOf(double var1);

    public JsonSchemaBuilder withMultipleOf(BigDecimal var1);

    default public JsonSchemaBuilder withMaximum(long value) {
        return this.withMaximum(BigDecimal.valueOf(value));
    }

    default public JsonSchemaBuilder withMaximum(double value) {
        return this.withMaximum(BigDecimal.valueOf(value));
    }

    public JsonSchemaBuilder withMaximum(BigDecimal var1);

    default public JsonSchemaBuilder withExclusiveMaximum(long value) {
        return this.withExclusiveMaximum(BigDecimal.valueOf(value));
    }

    default public JsonSchemaBuilder withExclusiveMaximum(double value) {
        return this.withExclusiveMaximum(BigDecimal.valueOf(value));
    }

    public JsonSchemaBuilder withExclusiveMaximum(BigDecimal var1);

    default public JsonSchemaBuilder withMinimum(long value) {
        return this.withMinimum(BigDecimal.valueOf(value));
    }

    default public JsonSchemaBuilder withMinimum(double value) {
        return this.withMinimum(BigDecimal.valueOf(value));
    }

    public JsonSchemaBuilder withMinimum(BigDecimal var1);

    default public JsonSchemaBuilder withExclusiveMinimum(long value) {
        return this.withExclusiveMinimum(BigDecimal.valueOf(value));
    }

    default public JsonSchemaBuilder withExclusiveMinimum(double value) {
        return this.withExclusiveMinimum(BigDecimal.valueOf(value));
    }

    public JsonSchemaBuilder withExclusiveMinimum(BigDecimal var1);

    public JsonSchemaBuilder withMaxLength(int var1);

    public JsonSchemaBuilder withMinLength(int var1);

    public JsonSchemaBuilder withPattern(String var1);

    public JsonSchemaBuilder withItems(JsonSchema var1);

    public JsonSchemaBuilder withItemsArray(JsonSchema ... var1);

    public JsonSchemaBuilder withItemsArray(List<JsonSchema> var1);

    public JsonSchemaBuilder withAdditionalItems(JsonSchema var1);

    public JsonSchemaBuilder withMaxItems(int var1);

    public JsonSchemaBuilder withMinItems(int var1);

    public JsonSchemaBuilder withUniqueItems(boolean var1);

    public JsonSchemaBuilder withContains(JsonSchema var1);

    public JsonSchemaBuilder withMaxContains(int var1);

    public JsonSchemaBuilder withMinContains(int var1);

    public JsonSchemaBuilder withMaxProperties(int var1);

    public JsonSchemaBuilder withMinProperties(int var1);

    public JsonSchemaBuilder withRequired(String ... var1);

    public JsonSchemaBuilder withRequired(Set<String> var1);

    public JsonSchemaBuilder withProperty(String var1, JsonSchema var2);

    public JsonSchemaBuilder withProperties(Map<String, JsonSchema> var1);

    public JsonSchemaBuilder withPatternProperty(String var1, JsonSchema var2);

    public JsonSchemaBuilder withPatternProperties(Map<String, JsonSchema> var1);

    public JsonSchemaBuilder withAdditionalProperties(JsonSchema var1);

    public JsonSchemaBuilder withDependency(String var1, JsonSchema var2);

    public JsonSchemaBuilder withDependency(String var1, String ... var2);

    public JsonSchemaBuilder withDependency(String var1, Set<String> var2);

    public JsonSchemaBuilder withDependencies(Map<String, ?> var1);

    public JsonSchemaBuilder withPropertyNames(JsonSchema var1);

    public JsonSchemaBuilder withIf(JsonSchema var1);

    public JsonSchemaBuilder withThen(JsonSchema var1);

    public JsonSchemaBuilder withElse(JsonSchema var1);

    public JsonSchemaBuilder withAllOf(JsonSchema ... var1);

    public JsonSchemaBuilder withAllOf(List<JsonSchema> var1);

    public JsonSchemaBuilder withAnyOf(JsonSchema ... var1);

    public JsonSchemaBuilder withAnyOf(List<JsonSchema> var1);

    public JsonSchemaBuilder withOneOf(JsonSchema ... var1);

    public JsonSchemaBuilder withOneOf(List<JsonSchema> var1);

    public JsonSchemaBuilder withNot(JsonSchema var1);

    public JsonSchemaBuilder withFormat(String var1);

    public JsonSchemaBuilder withLaxFormat(String var1);

    public JsonSchemaBuilder withContentEncoding(String var1);

    public JsonSchemaBuilder withContentMediaType(String var1);

    public JsonSchemaBuilder withDefinition(String var1, JsonSchema var2);

    public JsonSchemaBuilder withDefinitions(Map<String, JsonSchema> var1);

    public JsonSchemaBuilder withTitle(String var1);

    public JsonSchemaBuilder withDescription(String var1);

    public JsonSchemaBuilder withDefault(JsonValue var1);
}

