/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.api;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SpecVersion {
    DRAFT_04("http://json-schema.org/draft-04/schema#"),
    DRAFT_06("http://json-schema.org/draft-06/schema#"),
    DRAFT_07("http://json-schema.org/draft-07/schema#");

    private static final Map<URI, SpecVersion> VERSION_MAP;
    private final URI id;

    private SpecVersion(String id) {
        this.id = URI.create(id);
    }

    public URI id() {
        return this.id;
    }

    public static SpecVersion current() {
        return DRAFT_07;
    }

    public static SpecVersion getById(URI id) {
        Objects.requireNonNull(id, "id must not be null.");
        SpecVersion version = VERSION_MAP.get(id);
        if (version == null) {
            throw new IllegalArgumentException();
        }
        return version;
    }

    static {
        VERSION_MAP = Stream.of(SpecVersion.values()).collect(Collectors.toMap(SpecVersion::id, Function.identity()));
    }
}

