/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.leadpony.justify.api.Localizable;

class MessageFormatter {
    private final String input;
    private final ResourceBundle bundle;
    private int offset;
    private Map<String, Object> arguments;

    MessageFormatter(String input, ResourceBundle bundle) {
        this.input = input;
        this.bundle = bundle;
        this.offset = 0;
    }

    String format(Map<String, Object> arguments) {
        this.arguments = arguments;
        StringBuilder builder = new StringBuilder();
        while (this.hasNext()) {
            char c = this.next();
            if (c == '{') {
                builder.append(this.placeholder());
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String placeholder() {
        char c;
        StringBuilder builder = new StringBuilder();
        while (this.hasNext() && (c = this.next()) != '}') {
            builder.append(c);
        }
        return this.expandVariable(builder.toString());
    }

    private String expandVariable(String spec) {
        String[] tokens = spec.split("\\|");
        String name = tokens[0];
        Function<String, String> modifier = Function.identity();
        for (int i = 1; i < tokens.length; ++i) {
            modifier = modifier.andThen(Modifier.byName(tokens[i]));
        }
        Object value = this.resolveVariable(name);
        return this.stringify(value, modifier);
    }

    private Object resolveVariable(String name) {
        if (this.arguments.containsKey(name)) {
            return this.arguments.get(name);
        }
        throw new IllegalArgumentException("variable \"" + name + "\" is undefined.");
    }

    private String stringify(Object object, Function<String, String> modifier) {
        String string = null;
        if (object == null) {
            return "null";
        }
        if (object instanceof Collection) {
            return this.collectionToString(object, modifier);
        }
        string = object instanceof Localizable ? this.localizedToString(object) : (object instanceof Enum ? this.enumToString(object) : (object instanceof String ? this.stringToString(object) : object.toString()));
        return modifier.apply(string);
    }

    private boolean hasNext() {
        return this.offset < this.input.length();
    }

    private char next() {
        if (this.offset < this.input.length()) {
            return this.input.charAt(this.offset++);
        }
        throw new NoSuchElementException();
    }

    private String stringToString(Object object) {
        return (String)object;
    }

    private String localizedToString(Object object) {
        Localizable localized = (Localizable)object;
        return localized.getLocalized(this.bundle.getLocale());
    }

    private String enumToString(Object object) {
        Enum actual = (Enum)object;
        String className = actual.getClass().getSimpleName();
        String key = className + "." + actual.name();
        if (this.bundle.containsKey(key)) {
            return this.bundle.getString(key);
        }
        return actual.name();
    }

    private String collectionToString(Object object, Function<String, String> modifier) {
        Collection actual = (Collection)object;
        StringBuilder sb = new StringBuilder();
        return sb.append("[").append(actual.stream().map(item -> this.stringify(item, modifier)).collect(Collectors.joining(", "))).append("]").toString();
    }

    private static enum Modifier implements Function<String, String>
    {
        CAPITALIZE{

            @Override
            public String apply(String t) {
                if (t.isEmpty()) {
                    return t;
                }
                char[] chars = t.toCharArray();
                chars[0] = Character.toUpperCase(chars[0]);
                return new String(chars);
            }
        }
        ,
        QUOTE{

            @Override
            public String apply(String t) {
                return '\"' + t + '\"';
            }
        };


        @Override
        public String apply(String t) {
            return t;
        }

        public static Modifier byName(String name) {
            return Modifier.valueOf(name.toUpperCase());
        }
    }
}

