/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResettableInputStream
extends FilterInputStream {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    public ResettableInputStream(InputStream in) {
        super(in);
    }

    @Override
    public final int read() throws IOException {
        int b = super.read();
        if (b >= 0) {
            this.out.write(b);
        }
        return b;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (result > 0) {
            this.out.write(b);
        }
        return result;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            this.out.write(b, off, result);
        }
        return result;
    }

    @Override
    public final long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final InputStream createResettedStream() {
        return new SecondInputStream(this.in, this.out.toByteArray());
    }

    private static final class SecondInputStream
    extends FilterInputStream {
        private final byte[] buffer;
        private int index;

        private SecondInputStream(InputStream in, byte[] buffer) {
            super(in);
            this.buffer = buffer;
        }

        @Override
        public int read() throws IOException {
            if (this.index < this.buffer.length) {
                return this.buffer[this.index++];
            }
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.index < this.buffer.length) {
                if (this.index + len <= this.buffer.length) {
                    System.arraycopy(this.buffer, this.index, b, off, len);
                    this.index += len;
                    return len;
                }
                int firstLen = this.buffer.length - this.index;
                System.arraycopy(this.buffer, this.index, b, off, firstLen);
                this.index += firstLen;
                int secondLen = super.read(b, off + firstLen, len - firstLen);
                if (secondLen < 0) {
                    return firstLen;
                }
                return firstLen + secondLen;
            }
            return super.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.index < this.buffer.length) {
                if ((long)this.index + n <= (long)this.buffer.length) {
                    this.index = (int)((long)this.index + n);
                    return n;
                }
                long firstLen = this.buffer.length - this.index;
                this.index = this.buffer.length;
                return firstLen + super.skip(n - firstLen);
            }
            return super.skip(n);
        }
    }
}

