/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonException;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.Message;

abstract class AbstractJsonParser
implements JsonParser {
    private JsonParser.Event currentEvent;

    AbstractJsonParser() {
    }

    public void skipArray() {
        if (this.currentEvent != JsonParser.Event.START_ARRAY) {
            return;
        }
        int depth = 1;
        while (this.hasNext()) {
            JsonParser.Event event = this.next();
            if (event == JsonParser.Event.END_ARRAY) {
                if (--depth != 0) continue;
                break;
            }
            if (event != JsonParser.Event.START_ARRAY) continue;
            ++depth;
        }
    }

    public void skipObject() {
        if (this.currentEvent != JsonParser.Event.START_OBJECT) {
            return;
        }
        int depth = 1;
        while (this.hasNext()) {
            JsonParser.Event event = this.next();
            if (event == JsonParser.Event.END_OBJECT) {
                if (--depth != 0) continue;
                break;
            }
            if (event != JsonParser.Event.START_OBJECT) continue;
            ++depth;
        }
    }

    public Stream<JsonValue> getArrayStream() {
        if (this.currentEvent != JsonParser.Event.START_ARRAY) {
            throw this.newIllegalStateException("getArrayStream");
        }
        return StreamSupport.stream(new JsonArraySpliterator(), false);
    }

    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        if (this.currentEvent != JsonParser.Event.START_OBJECT) {
            throw this.newIllegalStateException("getObjectStream");
        }
        return StreamSupport.stream(new JsonObjectSpliterator(), false);
    }

    public Stream<JsonValue> getValueStream() {
        if (this.isInCollection()) {
            throw this.newIllegalStateException("getValueStream");
        }
        return StreamSupport.stream(new JsonValueSpliterator(), false);
    }

    public final JsonParser.Event getCurrentEvent() {
        return this.currentEvent;
    }

    protected final void setCurrentEvent(JsonParser.Event event) {
        this.currentEvent = event;
    }

    protected abstract JsonLocation getLastCharLocation();

    protected abstract boolean isInCollection();

    protected final IllegalStateException newIllegalStateException(String method) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("method", method);
        args.put("event", this.getCurrentEvent());
        String message = Message.PARSER_ILLEGAL_STATE.format(args);
        return new IllegalStateException(message);
    }

    protected final JsonParsingException newParsingException(JsonParser.Event ... expected) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("expected", Arrays.asList(expected));
        String message = Message.PARSER_UNEXPECTED_EOI.format(args);
        return new JsonParsingException(message, this.getLastCharLocation());
    }

    protected final JsonException newInternalError() {
        return new JsonException("Internal error");
    }

    private class JsonArraySpliterator
    extends AbstractSpliterator<JsonValue> {
        private JsonArraySpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super JsonValue> action) {
            Arguments.requireNonNull(action, "action");
            if (AbstractJsonParser.this.hasNext() && AbstractJsonParser.this.next() != JsonParser.Event.END_ARRAY) {
                action.accept((JsonValue)AbstractJsonParser.this.getValue());
                return true;
            }
            return false;
        }
    }

    private class JsonObjectSpliterator
    extends AbstractSpliterator<Map.Entry<String, JsonValue>> {
        private JsonObjectSpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<String, JsonValue>> action) {
            Arguments.requireNonNull(action, "action");
            if (!AbstractJsonParser.this.hasNext()) {
                return false;
            }
            JsonParser.Event event = AbstractJsonParser.this.next();
            if (event == JsonParser.Event.END_OBJECT) {
                return false;
            }
            if (event == JsonParser.Event.KEY_NAME) {
                String key = AbstractJsonParser.this.getString();
                if (!AbstractJsonParser.this.hasNext()) {
                    throw AbstractJsonParser.this.newParsingException(JsonParser.Event.START_OBJECT, JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_NULL);
                }
                AbstractJsonParser.this.next();
                JsonValue value = AbstractJsonParser.this.getValue();
                action.accept(new AbstractMap.SimpleImmutableEntry<String, JsonValue>(key, value));
                return true;
            }
            throw AbstractJsonParser.this.newInternalError();
        }
    }

    private class JsonValueSpliterator
    extends AbstractSpliterator<JsonValue> {
        private JsonValueSpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super JsonValue> action) {
            Arguments.requireNonNull("action", "action");
            if (AbstractJsonParser.this.hasNext()) {
                AbstractJsonParser.this.next();
                action.accept((JsonValue)AbstractJsonParser.this.getValue());
                return true;
            }
            return false;
        }
    }

    private static abstract class AbstractSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        protected AbstractSpliterator() {
            super(Long.MAX_VALUE, 16);
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }
    }
}

