/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import org.leadpony.justify.internal.base.json.AbstractJsonParser;
import org.leadpony.justify.internal.base.json.SimpleJsonLocation;

abstract class AbstractStreamJsonParser
extends AbstractJsonParser {
    private final JsonProvider jsonProvider;
    private final JsonBuilderFactory builderFactory;

    protected AbstractStreamJsonParser(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
        this.builderFactory = jsonProvider.createBuilderFactory(null);
    }

    public final JsonParser.Event next() {
        JsonParser.Event event = this.fetchNextEvent();
        event = this.process(event);
        this.setCurrentEvent(event);
        this.postprocess();
        return event;
    }

    public JsonArray getArray() {
        if (this.getCurrentEvent() != JsonParser.Event.START_ARRAY) {
            throw this.newIllegalStateException("getArray");
        }
        return this.buildArray();
    }

    public JsonObject getObject() {
        if (this.getCurrentEvent() != JsonParser.Event.START_OBJECT) {
            throw this.newIllegalStateException("getObject");
        }
        return this.buildObject();
    }

    public JsonValue getValue() {
        JsonParser.Event event = this.getCurrentEvent();
        if (event == null) {
            throw this.newIllegalStateException("getValue");
        }
        switch (event) {
            case START_ARRAY: {
                return this.buildArray();
            }
            case START_OBJECT: {
                return this.buildObject();
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case KEY_NAME: 
            case VALUE_STRING: {
                return this.getJsonString();
            }
            case VALUE_NUMBER: {
                return this.getJsonNumber();
            }
        }
        throw this.newIllegalStateException("getValue");
    }

    @Override
    protected JsonLocation getLastCharLocation() {
        return SimpleJsonLocation.before(this.getLocation());
    }

    public final JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public final JsonBuilderFactory getJsonBuilderFactory() {
        return this.builderFactory;
    }

    public JsonValue getJsonString() {
        return this.jsonProvider.createValue(this.getString());
    }

    public JsonValue getJsonNumber() {
        if (this.isIntegralNumber()) {
            return this.jsonProvider.createValue(this.getLong());
        }
        return this.jsonProvider.createValue(this.getBigDecimal());
    }

    protected abstract JsonParser.Event fetchNextEvent();

    protected JsonParser.Event process(JsonParser.Event event) {
        return event;
    }

    protected void postprocess() {
    }

    private JsonArray buildArray() {
        JsonArrayBuilder builder = this.getJsonBuilderFactory().createArrayBuilder();
        while (this.hasNext()) {
            JsonParser.Event event = this.next();
            if (event == JsonParser.Event.END_ARRAY) {
                return builder.build();
            }
            builder.add(this.getValue());
        }
        throw this.newParsingException(JsonParser.Event.START_OBJECT, JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_NULL, JsonParser.Event.END_ARRAY);
    }

    private JsonObject buildObject() {
        JsonObjectBuilder builder = this.getJsonBuilderFactory().createObjectBuilder();
        while (this.hasNext()) {
            JsonParser.Event event = this.next();
            if (event == JsonParser.Event.END_OBJECT) {
                return builder.build();
            }
            String name = this.getString();
            this.next();
            builder.add(name, this.getValue());
        }
        throw this.newParsingException(JsonParser.Event.KEY_NAME, JsonParser.Event.END_OBJECT);
    }
}

