/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;

class BigDecimalJsonNumber
implements JsonNumber {
    private final BigDecimal value;

    BigDecimalJsonNumber(BigDecimal value) {
        this.value = value;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public boolean isIntegral() {
        return this.value.scale() == 0;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public int intValueExact() {
        return this.value.intValueExact();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public long longValueExact() {
        return this.value.longValueExact();
    }

    public BigInteger bigIntegerValue() {
        return this.value.toBigInteger();
    }

    public BigInteger bigIntegerValueExact() {
        return this.value.toBigIntegerExact();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.stripTrailingZeros().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JsonNumber)) {
            return false;
        }
        JsonNumber otherNumber = (JsonNumber)other;
        return this.value.compareTo(otherNumber.bigDecimalValue()) == 0;
    }

    public String toString() {
        return this.value.toString();
    }
}

