/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.HashMap;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.json.SimpleJsonLocation;

public class DefaultJsonReader
implements JsonReader {
    private final JsonParser parser;
    private boolean alreadyRead;
    private boolean alreadyClosed;

    public DefaultJsonReader(JsonParser parser) {
        this.parser = parser;
    }

    public JsonStructure read() {
        if (this.alreadyRead || this.alreadyClosed) {
            throw new IllegalStateException("already read or closed");
        }
        this.alreadyRead = true;
        if (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            try {
                if (event == JsonParser.Event.START_ARRAY) {
                    return this.parser.getArray();
                }
                if (event == JsonParser.Event.START_OBJECT) {
                    return this.parser.getObject();
                }
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("event", event);
                String message = Message.READER_READ_ERROR.format(parameters);
                throw this.newParsingException(message);
            }
            catch (IllegalStateException e) {
                throw this.newParsingException(e);
            }
        }
        throw DefaultJsonReader.newUnexpectedEndOfInputException();
    }

    public JsonObject readObject() {
        if (this.alreadyRead || this.alreadyClosed) {
            throw new IllegalStateException("already read or closed");
        }
        this.alreadyRead = true;
        if (this.parser.hasNext()) {
            this.parser.next();
            try {
                return this.parser.getObject();
            }
            catch (IllegalStateException e) {
                throw this.newParsingException(e);
            }
        }
        throw DefaultJsonReader.newUnexpectedEndOfInputException();
    }

    public JsonArray readArray() {
        if (this.alreadyRead || this.alreadyClosed) {
            throw new IllegalStateException("already read or closed");
        }
        this.alreadyRead = true;
        if (this.parser.hasNext()) {
            this.parser.next();
            try {
                return this.parser.getArray();
            }
            catch (IllegalStateException e) {
                throw this.newParsingException(e);
            }
        }
        throw DefaultJsonReader.newUnexpectedEndOfInputException();
    }

    public JsonValue readValue() {
        if (this.alreadyRead || this.alreadyClosed) {
            throw new IllegalStateException("already read or closed");
        }
        this.alreadyRead = true;
        if (this.parser.hasNext()) {
            this.parser.next();
            try {
                return this.parser.getValue();
            }
            catch (IllegalStateException e) {
                throw this.newParsingException(e);
            }
        }
        throw DefaultJsonReader.newUnexpectedEndOfInputException();
    }

    public void close() {
        if (!this.alreadyClosed) {
            this.parser.close();
            this.alreadyClosed = true;
        }
    }

    private static JsonException newUnexpectedEndOfInputException() {
        String message = Message.READER_UNEXPECTED_EOI.getLocalized();
        return new JsonException(message);
    }

    private JsonParsingException newParsingException(String message) {
        JsonLocation location = SimpleJsonLocation.before(this.parser.getLocation());
        return new JsonParsingException(message, location);
    }

    private JsonParsingException newParsingException(Exception cause) {
        JsonLocation location = SimpleJsonLocation.before(this.parser.getLocation());
        return new JsonParsingException(cause.getMessage(), (Throwable)cause, location);
    }
}

