/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.json.JsonValueParser;

public class JsonParserFactoryDecorator
implements JsonParserFactory {
    private final JsonParserFactory real;

    public JsonParserFactoryDecorator(JsonParserFactory real) {
        Arguments.requireNonNull(real, "real");
        this.real = real;
    }

    public JsonParserFactory realFactory() {
        return this.real;
    }

    public JsonParser createParser(Reader reader) {
        return this.real.createParser(reader);
    }

    public JsonParser createParser(InputStream in) {
        return this.real.createParser(in);
    }

    public JsonParser createParser(InputStream in, Charset charset) {
        return this.real.createParser(in, charset);
    }

    public JsonParser createParser(JsonObject obj) {
        Arguments.requireNonNull(obj, "obj");
        return new JsonValueParser(obj);
    }

    public JsonParser createParser(JsonArray array) {
        Arguments.requireNonNull(array, "array");
        return new JsonValueParser(array);
    }

    public Map<String, ?> getConfigInUse() {
        return this.real.getConfigInUse();
    }
}

