/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JsonPointerTokenizer
implements Iterator<String> {
    private final String jsonPointer;
    private int offset;

    public JsonPointerTokenizer(String jsonPointer) {
        if (!jsonPointer.isEmpty() && !jsonPointer.startsWith("/")) {
            throw new JsonException("Invalid JSON pointer: " + jsonPointer);
        }
        this.jsonPointer = jsonPointer;
        this.offset = 0;
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.jsonPointer.length();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String token = null;
        int end = this.jsonPointer.indexOf(47, this.offset + 1);
        if (end >= 0) {
            token = this.jsonPointer.substring(this.offset + 1, end);
            this.offset = end;
        } else {
            token = this.jsonPointer.substring(this.offset + 1);
            this.offset = this.jsonPointer.length();
        }
        return JsonPointerTokenizer.decode(token);
    }

    public String remaining() {
        return this.jsonPointer.substring(this.offset);
    }

    private static String decode(String token) {
        return token.replaceAll("~1", "/").replaceAll("~0", "~");
    }
}

