/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParserFactory;
import java.util.Collections;

public class JsonService {
    private final JsonProvider jsonProvider;
    private final JsonBuilderFactory builderFactory;
    private final JsonParserFactory parserFactory;

    public JsonService(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
        this.builderFactory = jsonProvider.createBuilderFactory(Collections.emptyMap());
        this.parserFactory = jsonProvider.createParserFactory(Collections.emptyMap());
    }

    public final JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public final JsonBuilderFactory getJsonBuilderFactory() {
        return this.builderFactory;
    }

    public final JsonParserFactory getJsonParserFactory() {
        return this.parserFactory;
    }

    public final JsonArrayBuilder createArrayBuilder() {
        return this.getJsonBuilderFactory().createArrayBuilder();
    }

    public final JsonObjectBuilder createObjectBuilder() {
        return this.getJsonBuilderFactory().createObjectBuilder();
    }
}

