/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.leadpony.justify.internal.base.json.AbstractJsonParser;
import org.leadpony.justify.internal.base.json.SimpleJsonLocation;

public final class JsonValueParser
extends AbstractJsonParser {
    private static final Scope GLOBAL_SCOPE = new GlobalScope();
    private Scope scope;
    private static final JsonParser.Event[] VALUE_EVENTS = new JsonParser.Event[JsonValue.ValueType.values().length];

    public JsonValueParser(JsonArray value) {
        this.scope = new ArrayScope(value);
    }

    public JsonValueParser(List<JsonValue> value) {
        this.scope = new ArrayScope(value, GLOBAL_SCOPE);
    }

    public JsonValueParser(JsonObject value) {
        this.scope = new ObjectScope(value);
    }

    public JsonValueParser(Map<String, JsonValue> value) {
        this.scope = new ObjectScope(value, GLOBAL_SCOPE);
    }

    public boolean hasNext() {
        return this.scope != GLOBAL_SCOPE;
    }

    public JsonParser.Event next() {
        JsonParser.Event event = this.scope.getEvent(this);
        this.setCurrentEvent(event);
        return event;
    }

    public String getString() {
        JsonParser.Event event = this.getCurrentEvent();
        if (event == null) {
            throw this.newIllegalStateException("getString");
        }
        switch (event) {
            case KEY_NAME: {
                return this.scope.getKey();
            }
            case VALUE_STRING: {
                JsonString string = (JsonString)this.scope.getValue();
                return string.getString();
            }
            case VALUE_NUMBER: {
                return this.scope.getValue().toString();
            }
        }
        throw this.newIllegalStateException("getString");
    }

    public boolean isIntegralNumber() {
        if (this.getCurrentEvent() != JsonParser.Event.VALUE_NUMBER) {
            throw this.newIllegalStateException("isIntegralNumber");
        }
        JsonNumber number = (JsonNumber)this.scope.getValue();
        return number.isIntegral();
    }

    public int getInt() {
        if (this.getCurrentEvent() != JsonParser.Event.VALUE_NUMBER) {
            throw this.newIllegalStateException("getInt");
        }
        JsonNumber number = (JsonNumber)this.scope.getValue();
        return number.intValue();
    }

    public long getLong() {
        if (this.getCurrentEvent() != JsonParser.Event.VALUE_NUMBER) {
            throw this.newIllegalStateException("getLong");
        }
        JsonNumber number = (JsonNumber)this.scope.getValue();
        return number.longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.getCurrentEvent() != JsonParser.Event.VALUE_NUMBER) {
            throw this.newIllegalStateException("getBigDecimal");
        }
        JsonNumber number = (JsonNumber)this.scope.getValue();
        return number.bigDecimalValue();
    }

    public JsonLocation getLocation() {
        return SimpleJsonLocation.UNKNOWN;
    }

    public JsonObject getObject() {
        if (this.getCurrentEvent() != JsonParser.Event.START_OBJECT) {
            throw this.newIllegalStateException("getObject");
        }
        return (JsonObject)this.scope.getValue();
    }

    public JsonValue getValue() {
        JsonParser.Event event = this.getCurrentEvent();
        if (event == JsonParser.Event.END_ARRAY || event == JsonParser.Event.END_OBJECT || event == null) {
            throw this.newIllegalStateException("getValue");
        }
        return this.scope.getValue();
    }

    public JsonArray getArray() {
        if (this.getCurrentEvent() != JsonParser.Event.START_ARRAY) {
            throw this.newIllegalStateException("getArray");
        }
        return (JsonArray)this.scope.getValue();
    }

    public void close() {
    }

    @Override
    protected JsonLocation getLastCharLocation() {
        return SimpleJsonLocation.UNKNOWN;
    }

    @Override
    protected boolean isInCollection() {
        return this.getCurrentEvent() != null;
    }

    private void setScope(Scope scope) {
        this.scope = scope;
    }

    private static JsonParser.Event getEventStarting(JsonValue value) {
        return VALUE_EVENTS[value.getValueType().ordinal()];
    }

    static {
        JsonValueParser.VALUE_EVENTS[JsonValue.ValueType.ARRAY.ordinal()] = JsonParser.Event.START_ARRAY;
        JsonValueParser.VALUE_EVENTS[JsonValue.ValueType.OBJECT.ordinal()] = JsonParser.Event.START_OBJECT;
        JsonValueParser.VALUE_EVENTS[JsonValue.ValueType.STRING.ordinal()] = JsonParser.Event.VALUE_STRING;
        JsonValueParser.VALUE_EVENTS[JsonValue.ValueType.NUMBER.ordinal()] = JsonParser.Event.VALUE_NUMBER;
        JsonValueParser.VALUE_EVENTS[JsonValue.ValueType.TRUE.ordinal()] = JsonParser.Event.VALUE_TRUE;
        JsonValueParser.VALUE_EVENTS[JsonValue.ValueType.FALSE.ordinal()] = JsonParser.Event.VALUE_FALSE;
        JsonValueParser.VALUE_EVENTS[JsonValue.ValueType.NULL.ordinal()] = JsonParser.Event.VALUE_NULL;
    }

    static interface Scope {
        public JsonParser.Event getEvent(JsonValueParser var1);

        default public String getKey() {
            throw new UnsupportedOperationException();
        }

        public JsonValue getValue();
    }

    static class ArrayScope
    extends CollectionScope {
        private final List<JsonValue> items;
        private final int length;
        private int index;
        private ArrayState state;
        private JsonValue currentValue;

        ArrayScope(JsonArray array) {
            super(GLOBAL_SCOPE);
            this.items = array;
            this.length = array.size();
            this.state = ArrayState.START;
            this.currentValue = array;
        }

        ArrayScope(List<JsonValue> items, Scope outerScope) {
            super(outerScope);
            this.items = items;
            this.length = items.size();
            this.state = ArrayState.ITEM;
            this.currentValue = null;
        }

        @Override
        public JsonParser.Event getEvent(JsonValueParser parser) {
            return this.state.process(parser, this);
        }

        @Override
        public JsonValue getValue() {
            return this.currentValue;
        }

        final boolean hasNext() {
            return this.index < this.length;
        }

        final JsonValue getNext() {
            return this.items.get(this.index++);
        }

        final void setState(ArrayState state) {
            this.state = state;
        }

        final void setValue(JsonValue value) {
            this.currentValue = value;
        }

        static enum ArrayState {
            START{

                @Override
                public JsonParser.Event process(JsonValueParser parser, ArrayScope scope) {
                    scope.setState(ITEM);
                    return JsonParser.Event.START_ARRAY;
                }
            }
            ,
            ITEM{

                @Override
                public JsonParser.Event process(JsonValueParser parser, ArrayScope scope) {
                    JsonParser.Event event;
                    if (scope.hasNext()) {
                        JsonValue value = scope.getNext();
                        event = JsonValueParser.getEventStarting(value);
                        switch (event) {
                            case START_ARRAY: {
                                parser.setScope(new ArrayScope((List<JsonValue>)((JsonArray)value), scope));
                                break;
                            }
                            case START_OBJECT: {
                                parser.setScope(new ObjectScope((Map<String, JsonValue>)((JsonObject)value), scope));
                                break;
                            }
                        }
                        scope.setValue(value);
                    } else {
                        event = JsonParser.Event.END_ARRAY;
                        scope.setValue(null);
                        parser.setScope(scope.getOuterScope());
                    }
                    return event;
                }
            };


            abstract JsonParser.Event process(JsonValueParser var1, ArrayScope var2);
        }
    }

    static class ObjectScope
    extends CollectionScope {
        private final Iterator<Map.Entry<String, JsonValue>> iterator;
        private ObjectState state;
        private String keyName;
        private JsonValue currentValue;

        ObjectScope(JsonObject object) {
            super(GLOBAL_SCOPE);
            this.iterator = object.entrySet().iterator();
            this.state = ObjectState.START;
            this.currentValue = object;
        }

        ObjectScope(Map<String, JsonValue> properties, Scope outerScope) {
            super(outerScope);
            this.iterator = properties.entrySet().iterator();
            this.state = ObjectState.KEY;
            this.currentValue = null;
        }

        @Override
        public JsonParser.Event getEvent(JsonValueParser parser) {
            return this.state.process(parser, this);
        }

        @Override
        public final String getKey() {
            return this.keyName;
        }

        @Override
        public final JsonValue getValue() {
            return this.currentValue;
        }

        final boolean fetchProperty() {
            if (this.iterator.hasNext()) {
                Map.Entry<String, JsonValue> entry = this.iterator.next();
                this.keyName = entry.getKey();
                this.currentValue = entry.getValue();
                return true;
            }
            this.keyName = null;
            this.currentValue = null;
            return false;
        }

        final void setState(ObjectState state) {
            this.state = state;
        }

        static enum ObjectState {
            START{

                @Override
                public JsonParser.Event process(JsonValueParser parser, ObjectScope scope) {
                    scope.setState(KEY);
                    return JsonParser.Event.START_OBJECT;
                }
            }
            ,
            KEY{

                @Override
                public JsonParser.Event process(JsonValueParser parser, ObjectScope scope) {
                    if (scope.fetchProperty()) {
                        scope.setState(VALUE);
                        return JsonParser.Event.KEY_NAME;
                    }
                    parser.setScope(scope.getOuterScope());
                    return JsonParser.Event.END_OBJECT;
                }
            }
            ,
            VALUE{

                @Override
                public JsonParser.Event process(JsonValueParser parser, ObjectScope scope) {
                    JsonValue value = scope.getValue();
                    JsonParser.Event event = JsonValueParser.getEventStarting(value);
                    switch (event) {
                        case START_ARRAY: {
                            parser.setScope(new ArrayScope((List<JsonValue>)((JsonArray)value), scope));
                            break;
                        }
                        case START_OBJECT: {
                            parser.setScope(new ObjectScope((Map<String, JsonValue>)((JsonObject)value), scope));
                            break;
                        }
                    }
                    scope.setState(KEY);
                    return event;
                }
            };


            abstract JsonParser.Event process(JsonValueParser var1, ObjectScope var2);
        }
    }

    static class GlobalScope
    implements Scope {
        GlobalScope() {
        }

        @Override
        public JsonParser.Event getEvent(JsonValueParser parser) {
            throw new NoSuchElementException();
        }

        @Override
        public JsonValue getValue() {
            throw new IllegalStateException();
        }
    }

    static abstract class CollectionScope
    implements Scope {
        private final Scope outerScope;

        CollectionScope(Scope outerScope) {
            this.outerScope = outerScope;
        }

        final Scope getOuterScope() {
            return this.outerScope;
        }
    }
}

