/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import org.leadpony.justify.api.InstanceType;

public final class ParserEvents {
    private static final EnumSet<JsonParser.Event> VALUE_EVENTS = EnumSet.of(JsonParser.Event.START_ARRAY, new JsonParser.Event[]{JsonParser.Event.START_OBJECT, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_NULL});

    public static InstanceType toBroadInstanceType(JsonParser.Event event) {
        switch (event) {
            case START_ARRAY: {
                return InstanceType.ARRAY;
            }
            case START_OBJECT: {
                return InstanceType.OBJECT;
            }
            case KEY_NAME: 
            case VALUE_STRING: {
                return InstanceType.STRING;
            }
            case VALUE_NUMBER: {
                return InstanceType.NUMBER;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return InstanceType.BOOLEAN;
            }
            case VALUE_NULL: {
                return InstanceType.NULL;
            }
        }
        return null;
    }

    public static boolean isStartOfContainer(JsonParser.Event event) {
        return event == JsonParser.Event.START_ARRAY || event == JsonParser.Event.START_OBJECT;
    }

    public static boolean isEndOfContainer(JsonParser.Event event) {
        return event == JsonParser.Event.END_ARRAY || event == JsonParser.Event.END_OBJECT;
    }

    public static boolean isValue(JsonParser.Event event) {
        return VALUE_EVENTS.contains(event);
    }

    public static JsonParser.Event fromValue(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case STRING: {
                return JsonParser.Event.VALUE_STRING;
            }
            case NUMBER: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
            case FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
        }
        throw new IllegalStateException();
    }

    private ParserEvents() {
    }
}

