/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.regex;

import java.util.regex.Pattern;

public final class Ecma262Pattern {
    private static final String WHITESPACE_CHARACTER = "\\h\\f\\n\\r\\u000b\u200b\\u2028\\u2029\\ufeff";
    private static final String WHITESPACE_CHARACTER_CLASS = "[\\h\\f\\n\\r\\u000b\u200b\\u2028\\u2029\\ufeff]";
    private static final String NON_WHITESPACE_CHARACTER_CLASS = "[^\\h\\f\\n\\r\\u000b\u200b\\u2028\\u2029\\ufeff]";

    public static Pattern compile(String regex) {
        String translated = Ecma262Pattern.translate(regex);
        return Pattern.compile(translated);
    }

    private static String translate(String regex) {
        StringBuilder builder = new StringBuilder();
        int length = regex.length();
        for (int i = 0; i < length; ++i) {
            char c = regex.charAt(i);
            if (c == '\\') {
                if (++i < length) {
                    c = regex.charAt(i);
                    if (c == 'c') {
                        if (++i >= length) continue;
                        c = regex.charAt(i);
                        if ('a' <= c && c <= 'z') {
                            builder.append("\\c");
                            builder.append((char)(65 + c - 97));
                            continue;
                        }
                        builder.append("\\c").append(c);
                        continue;
                    }
                    if (c == 's') {
                        builder.append(WHITESPACE_CHARACTER_CLASS);
                        continue;
                    }
                    if (c == 'S') {
                        builder.append(NON_WHITESPACE_CHARACTER_CLASS);
                        continue;
                    }
                    builder.append("\\").append(c);
                    continue;
                }
                builder.append("\\");
                continue;
            }
            if (c == '$' && i + 1 >= length) {
                builder.append("\\z");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private Ecma262Pattern() {
    }
}

