/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer2;

public enum IdnProperty {
    PVALID,
    CONTEXTJ,
    CONTEXTO,
    DISALLOWED,
    UNASSIGNED;


    public static IdnProperty of(int codePoint) {
        IdnProperty property = IdnProperty.asExceptional(codePoint);
        if (property != null) {
            return property;
        }
        if (IdnProperty.isUnassigned(codePoint)) {
            return UNASSIGNED;
        }
        if (IdnProperty.isLDH(codePoint)) {
            return PVALID;
        }
        if (IdnProperty.isJoinControl(codePoint)) {
            return CONTEXTJ;
        }
        if (IdnProperty.isUnstable(codePoint)) {
            return DISALLOWED;
        }
        if (IdnProperty.isIgnorableProperties(codePoint)) {
            return DISALLOWED;
        }
        if (IdnProperty.isIgnorableBlocks(codePoint)) {
            return DISALLOWED;
        }
        if (IdnProperty.isOldHangulJamo(codePoint)) {
            return DISALLOWED;
        }
        if (IdnProperty.isLetterDigit(codePoint)) {
            return PVALID;
        }
        return DISALLOWED;
    }

    private static IdnProperty asExceptional(int codePoint) {
        switch (codePoint) {
            case 223: 
            case 962: 
            case 1789: 
            case 1790: 
            case 3851: 
            case 12295: {
                return PVALID;
            }
            case 183: 
            case 885: 
            case 1523: 
            case 1524: 
            case 12539: {
                return CONTEXTO;
            }
            case 1632: 
            case 1633: 
            case 1634: 
            case 1635: 
            case 1636: 
            case 1637: 
            case 1638: 
            case 1639: 
            case 1640: 
            case 1641: 
            case 1776: 
            case 1777: 
            case 1778: 
            case 1779: 
            case 1780: 
            case 1781: 
            case 1782: 
            case 1783: 
            case 1784: 
            case 1785: {
                return CONTEXTO;
            }
            case 1600: 
            case 2042: 
            case 12334: 
            case 12335: 
            case 12337: 
            case 12338: 
            case 12339: 
            case 12340: 
            case 12341: 
            case 12347: {
                return DISALLOWED;
            }
        }
        return null;
    }

    private static boolean isLetterDigit(int codePoint) {
        int type = Character.getType(codePoint);
        return type == 2 || type == 1 || type == 5 || type == 9 || type == 4 || type == 6 || type == 8;
    }

    private static boolean isUnassigned(int codePoint) {
        return Character.getType(codePoint) == 0 && !IdnProperty.isNoncharacter(codePoint);
    }

    private static boolean isLDH(int codePoint) {
        return codePoint == 45 || codePoint >= 48 && codePoint <= 57 || codePoint >= 97 && codePoint <= 122;
    }

    private static boolean isJoinControl(int codePoint) {
        return codePoint == 8204 || codePoint == 8205;
    }

    private static boolean isUnstable(int codePoint) {
        String normalized;
        String folded;
        Normalizer2 normalizer;
        String result;
        String original = String.valueOf(Character.toChars(codePoint));
        return !original.equals(result = (normalizer = Normalizer2.getNFKCInstance()).normalize((CharSequence)(folded = UCharacter.foldCase((String)(normalized = normalizer.normalize((CharSequence)original)), (int)0))));
    }

    private static boolean isIgnorableProperties(int codePoint) {
        return IdnProperty.isDefaultIgnorable(codePoint) || Character.isWhitespace(codePoint) || IdnProperty.isNoncharacter(codePoint);
    }

    private static boolean isDefaultIgnorable(int codePoint) {
        return codePoint == 173 || codePoint == 847 || codePoint >= 4447 && codePoint <= 4448 || codePoint >= 6068 && codePoint <= 6069 || codePoint >= 6155 && codePoint <= 6157 || codePoint >= 8203 && codePoint <= 8207 || codePoint >= 8234 && codePoint <= 8238 || codePoint >= 8288 && codePoint <= 8292 || codePoint >= 8293 && codePoint <= 8297 || codePoint >= 8298 && codePoint <= 8303 || codePoint == 12644 || codePoint >= 65024 && codePoint <= 65039 || codePoint == 65279 || codePoint == 65440 || codePoint >= 65520 && codePoint <= 65528 || codePoint >= 119155 && codePoint <= 119162 || codePoint >= 917504 && codePoint <= 921599;
    }

    private static boolean isIgnorableBlocks(int codePoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        return block == Character.UnicodeBlock.COMBINING_MARKS_FOR_SYMBOLS || block == Character.UnicodeBlock.MUSICAL_SYMBOLS || block == Character.UnicodeBlock.ANCIENT_GREEK_MUSICAL_NOTATION;
    }

    private static boolean isOldHangulJamo(int codePoint) {
        if (4352 <= codePoint && codePoint <= 4447 || 43360 <= codePoint && codePoint <= 43388) {
            return true;
        }
        if (4448 <= codePoint && codePoint <= 4519 || 55216 <= codePoint && codePoint <= 55238) {
            return true;
        }
        return 4520 <= codePoint && codePoint <= 4607 || 55243 <= codePoint && codePoint <= 55291;
    }

    private static boolean isNoncharacter(int codePoint) {
        if (codePoint >= 64976 && codePoint <= 65007) {
            return true;
        }
        int lower = codePoint & 0xFFFF;
        return lower == 65534 || lower == 65535;
    }
}

