/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.AbstractLogicalEvaluator;
import org.leadpony.justify.internal.evaluator.ChildrenEvaluator;

public abstract class AbstractConjunctiveItemsEvaluator
extends AbstractLogicalEvaluator
implements ChildrenEvaluator {
    private Evaluator.Result finalResult = Evaluator.Result.TRUE;
    private Evaluator childEvaluator;

    protected AbstractConjunctiveItemsEvaluator(EvaluatorContext context) {
        super(context);
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        Evaluator.Result result;
        if (depth == 0 && event == JsonParser.Event.END_ARRAY) {
            return this.finalResult;
        }
        if (depth == 1) {
            this.updateChildren(event, this.getParser());
        }
        if (this.childEvaluator != null && (result = this.childEvaluator.evaluate(event, depth - 1, dispatcher)) != Evaluator.Result.PENDING) {
            if (result == Evaluator.Result.FALSE) {
                this.finalResult = Evaluator.Result.FALSE;
            }
            this.childEvaluator = null;
        }
        return Evaluator.Result.PENDING;
    }

    @Override
    public void append(Evaluator evaluator) {
        if (evaluator == Evaluator.ALWAYS_TRUE) {
            return;
        }
        assert (this.childEvaluator == null);
        this.childEvaluator = evaluator;
    }
}

