/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.AbstractEvaluator;
import org.leadpony.justify.internal.evaluator.DeferredEvaluator;
import org.leadpony.justify.internal.problem.SilentProblemDispatcher;

public class ConditionalEvaluator
extends AbstractEvaluator {
    private final Evaluator ifEvaluator;
    private final DeferredEvaluator thenEvaluator;
    private final DeferredEvaluator elseEvaluator;
    private Evaluator.Result ifResult;
    private Evaluator.Result thenResult;
    private Evaluator.Result elseResult;

    public ConditionalEvaluator(EvaluatorContext context, Evaluator ifEvaluator, Evaluator thenEvaluator, Evaluator elseEvaluator) {
        super(context);
        assert (ifEvaluator != null);
        assert (thenEvaluator != null);
        assert (elseEvaluator != null);
        this.ifEvaluator = ifEvaluator;
        this.thenEvaluator = new DeferredEvaluator(thenEvaluator);
        this.elseEvaluator = new DeferredEvaluator(elseEvaluator);
        this.ifResult = Evaluator.Result.PENDING;
        this.thenResult = Evaluator.Result.PENDING;
        this.elseResult = Evaluator.Result.PENDING;
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        this.ifResult = this.updateEvaluation(this.ifResult, this.ifEvaluator, event, depth, SilentProblemDispatcher.SINGLETON);
        if (this.ifResult == Evaluator.Result.TRUE) {
            this.thenResult = this.updateEvaluation(this.thenResult, this.thenEvaluator, event, depth, dispatcher);
            if (this.thenResult != Evaluator.Result.PENDING) {
                return this.finalizeEvaluation(this.thenResult, this.thenEvaluator, dispatcher);
            }
        } else if (this.ifResult == Evaluator.Result.FALSE) {
            this.elseResult = this.updateEvaluation(this.elseResult, this.elseEvaluator, event, depth, dispatcher);
            if (this.elseResult != Evaluator.Result.PENDING) {
                return this.finalizeEvaluation(this.elseResult, this.elseEvaluator, dispatcher);
            }
        } else {
            this.thenResult = this.updateEvaluation(this.thenResult, this.thenEvaluator, event, depth, dispatcher);
            this.elseResult = this.updateEvaluation(this.elseResult, this.elseEvaluator, event, depth, dispatcher);
        }
        return Evaluator.Result.PENDING;
    }

    private Evaluator.Result updateEvaluation(Evaluator.Result result, Evaluator evaluator, JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        if (result == Evaluator.Result.PENDING) {
            return evaluator.evaluate(event, depth, dispatcher);
        }
        return result;
    }

    private Evaluator.Result finalizeEvaluation(Evaluator.Result result, DeferredEvaluator evaluator, ProblemDispatcher dispatcher) {
        if (result == Evaluator.Result.FALSE) {
            evaluator.problems().forEach(problem -> dispatcher.dispatchProblem((Problem)problem));
        }
        return result;
    }
}

