/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.Iterator;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.SimpleConjunctiveEvaluator;

class ConjunctiveEvaluator
extends SimpleConjunctiveEvaluator {
    private static final long serialVersionUID = 1L;
    private final JsonParser.Event closingEvent;
    private Evaluator.Result finalResult = Evaluator.Result.TRUE;

    ConjunctiveEvaluator(JsonParser.Event closingEvent) {
        this.closingEvent = closingEvent;
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        this.invokeOperandEvaluators(event, depth, dispatcher);
        if (depth == 0 && event == this.closingEvent) {
            return this.finalResult;
        }
        return Evaluator.Result.PENDING;
    }

    protected Evaluator.Result invokeOperandEvaluators(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Evaluator.Result result = ((Evaluator)it.next()).evaluate(event, depth, dispatcher);
            if (result == Evaluator.Result.PENDING) continue;
            if (result == Evaluator.Result.FALSE) {
                this.finalResult = Evaluator.Result.FALSE;
            }
            it.remove();
        }
        return Evaluator.Result.PENDING;
    }
}

