/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.stream.Stream;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.ConjunctiveEvaluator;
import org.leadpony.justify.internal.evaluator.DisjunctiveEvaluator;
import org.leadpony.justify.internal.evaluator.ExclusiveEvaluator;
import org.leadpony.justify.internal.evaluator.LogicalEvaluator;
import org.leadpony.justify.internal.evaluator.NotExclusiveEvaluator;
import org.leadpony.justify.internal.evaluator.SimpleConjunctiveEvaluator;
import org.leadpony.justify.internal.evaluator.SimpleDisjunctiveEvaluator;
import org.leadpony.justify.internal.evaluator.SimpleExclusiveEvaluator;
import org.leadpony.justify.internal.evaluator.SimpleNotExclusiveEvaluator;

public final class Evaluators {
    private Evaluators() {
    }

    public static Evaluator alwaysFalse(final JsonSchema schema, final EvaluatorContext context) {
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                dispatcher.dispatchInevitableProblem(context, schema);
                return Evaluator.Result.FALSE;
            }

            @Override
            public boolean isAlwaysFalse() {
                return true;
            }
        };
    }

    public static LogicalEvaluator conjunctive(InstanceType type) {
        switch (type) {
            case ARRAY: {
                return new ConjunctiveEvaluator(JsonParser.Event.END_ARRAY);
            }
            case OBJECT: {
                return new ConjunctiveEvaluator(JsonParser.Event.END_OBJECT);
            }
        }
        return new SimpleConjunctiveEvaluator();
    }

    public static LogicalEvaluator disjunctive(EvaluatorContext context, InstanceType type) {
        switch (type) {
            case ARRAY: {
                return new DisjunctiveEvaluator(context, JsonParser.Event.END_ARRAY);
            }
            case OBJECT: {
                return new DisjunctiveEvaluator(context, JsonParser.Event.END_OBJECT);
            }
        }
        return new SimpleDisjunctiveEvaluator(context);
    }

    public static LogicalEvaluator exclusive(EvaluatorContext context, InstanceType type, Stream<Evaluator> operands, Stream<Evaluator> negated) {
        switch (type) {
            case ARRAY: {
                return new ExclusiveEvaluator(context, JsonParser.Event.END_ARRAY, operands, negated);
            }
            case OBJECT: {
                return new ExclusiveEvaluator(context, JsonParser.Event.END_OBJECT, operands, negated);
            }
        }
        return new SimpleExclusiveEvaluator(context, operands, negated);
    }

    public static LogicalEvaluator notExclusive(EvaluatorContext context, InstanceType type) {
        switch (type) {
            case ARRAY: {
                return new NotExclusiveEvaluator(context, JsonParser.Event.END_ARRAY);
            }
            case OBJECT: {
                return new NotExclusiveEvaluator(context, JsonParser.Event.END_OBJECT);
            }
        }
        return new SimpleNotExclusiveEvaluator(context);
    }
}

