/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.evaluator.AbstractLogicalEvaluator;
import org.leadpony.justify.internal.evaluator.DeferredEvaluator;
import org.leadpony.justify.internal.problem.ProblemBuilder;
import org.leadpony.justify.internal.problem.ProblemList;

class SimpleDisjunctiveEvaluator
extends AbstractLogicalEvaluator
implements Iterable<DeferredEvaluator> {
    private final List<DeferredEvaluator> operands = new ArrayList<DeferredEvaluator>();
    private List<ProblemList> problemLists;

    SimpleDisjunctiveEvaluator(EvaluatorContext context) {
        super(context);
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        for (DeferredEvaluator operand : this.operands) {
            Evaluator.Result result = operand.evaluate(event, depth, dispatcher);
            if (result == Evaluator.Result.TRUE) {
                return Evaluator.Result.TRUE;
            }
            this.addBadEvaluator(operand);
        }
        return this.dispatchProblems(dispatcher);
    }

    @Override
    public void append(Evaluator evaluator) {
        this.operands.add(new DeferredEvaluator(evaluator));
    }

    @Override
    public Iterator<DeferredEvaluator> iterator() {
        return this.operands.iterator();
    }

    protected void addBadEvaluator(DeferredEvaluator evaluator) {
        if (this.problemLists == null) {
            this.problemLists = new ArrayList<ProblemList>();
        }
        this.problemLists.add(evaluator.problems());
    }

    protected Evaluator.Result dispatchProblems(ProblemDispatcher dispatcher) {
        if (this.problemLists == null) {
            this.dispatchDefaultProblem(dispatcher);
        } else {
            assert (!this.problemLists.isEmpty());
            this.dispatchProblemBranches(dispatcher);
        }
        return Evaluator.Result.FALSE;
    }

    private void dispatchProblemBranches(ProblemDispatcher dispatcher) {
        List<Object> filterdLists = this.problemLists.stream().filter(ProblemList::isResolvable).collect(Collectors.toList());
        if (filterdLists.isEmpty()) {
            filterdLists = this.problemLists;
        }
        ProblemBuilder builder = this.createProblemBuilder(this.getContext()).withMessage(this.getMessage()).withBranches(filterdLists);
        dispatcher.dispatchProblem(builder.build());
    }

    protected Message getMessage() {
        return Message.INSTANCE_PROBLEM_ANYOF;
    }

    protected void dispatchDefaultProblem(ProblemDispatcher dispatcher) {
        throw new IllegalStateException();
    }
}

