/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.AbstractExclusiveEvaluator;
import org.leadpony.justify.internal.evaluator.DeferredEvaluator;
import org.leadpony.justify.internal.problem.ProblemList;

class SimpleExclusiveEvaluator
extends AbstractExclusiveEvaluator {
    private final Stream<Evaluator> operands;
    private final Stream<Evaluator> negated;

    SimpleExclusiveEvaluator(EvaluatorContext context, Stream<Evaluator> operands, Stream<Evaluator> negated) {
        super(context);
        this.operands = operands;
        this.negated = negated;
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        int evaluationsAsTrue = this.evaluateAll(event, depth, dispatcher);
        if (evaluationsAsTrue == 1) {
            return Evaluator.Result.TRUE;
        }
        if (evaluationsAsTrue > 1) {
            this.evaluateAllNegated(event, depth, dispatcher);
        }
        return Evaluator.Result.FALSE;
    }

    private static Iterator<DeferredEvaluator> iterator(Stream<Evaluator> stream) {
        return stream.map(DeferredEvaluator::new).iterator();
    }

    private int evaluateAll(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        ArrayList<ProblemList> problemLists = new ArrayList<ProblemList>();
        Iterator<DeferredEvaluator> it = SimpleExclusiveEvaluator.iterator(this.operands);
        int evaluationsAsTrue = 0;
        while (it.hasNext()) {
            DeferredEvaluator current = it.next();
            Evaluator.Result result = current.evaluate(event, depth, dispatcher);
            if (result == Evaluator.Result.TRUE) {
                ++evaluationsAsTrue;
                continue;
            }
            if (result == Evaluator.Result.FALSE) {
                problemLists.add(current.problems());
                continue;
            }
            assert (false);
        }
        if (evaluationsAsTrue == 0) {
            this.dispatchProblems(dispatcher, problemLists);
        }
        return evaluationsAsTrue;
    }

    private void evaluateAllNegated(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        ArrayList<ProblemList> problemLists = new ArrayList<ProblemList>();
        Iterator<DeferredEvaluator> it = SimpleExclusiveEvaluator.iterator(this.negated);
        while (it.hasNext()) {
            DeferredEvaluator current = it.next();
            Evaluator.Result result = current.evaluate(event, depth, dispatcher);
            if (result != Evaluator.Result.FALSE) continue;
            problemLists.add(current.problems());
        }
        this.dispatchNegatedProblems(dispatcher, problemLists);
    }
}

