/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.evaluator.AbstractEvaluator;
import org.leadpony.justify.internal.evaluator.Evaluators;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.problem.ProblemBuilder;
import org.leadpony.justify.internal.problem.ProblemBuilderFactory;

public abstract class AbstractKeyword
implements SchemaKeyword,
ProblemBuilderFactory {
    private final String name;
    private final JsonValue json;
    private JsonSchema schema;

    protected AbstractKeyword(JsonValue json) {
        this.name = this.guessOwnName();
        this.json = json;
    }

    protected AbstractKeyword(String name, JsonValue json) {
        this.name = name;
        this.json = json;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final JsonValue getValueAsJson() {
        return this.json;
    }

    @Override
    public JsonSchema getEnclosingSchema() {
        return this.schema;
    }

    @Override
    public void setEnclosingSchema(JsonSchema schema) {
        this.schema = schema;
    }

    @Override
    public Evaluator createEvaluator(EvaluatorContext context, InstanceType type) {
        assert (context != null);
        if (!this.supportsType(type)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return this.doCreateEvaluator(context, type);
    }

    @Override
    public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        assert (context != null);
        if (!this.supportsType(type)) {
            return new TypeMismatchEvaluator(context, type);
        }
        return this.doCreateNegatedEvaluator(context, type);
    }

    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        throw new UnsupportedOperationException(this.name() + " does not support evaluation.");
    }

    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        throw new UnsupportedOperationException(this.name() + " does not support evaluation.");
    }

    protected final Evaluator createAlwaysFalseEvaluator(EvaluatorContext context) {
        return Evaluators.alwaysFalse(this.getEnclosingSchema(), context);
    }

    @Override
    public ProblemBuilder createProblemBuilder(EvaluatorContext context) {
        return ProblemBuilderFactory.super.createProblemBuilder(context).withSchema(this.schema).withKeyword(this.name());
    }

    private String guessOwnName() {
        KeywordType keywordType = this.getClass().getAnnotation(KeywordType.class);
        return keywordType.value();
    }

    private final class TypeMismatchEvaluator
    extends AbstractEvaluator {
        private final InstanceType actual;

        private TypeMismatchEvaluator(EvaluatorContext context, InstanceType actual) {
            super(context);
            this.actual = actual;
        }

        @Override
        public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            Set<InstanceType> expected = AbstractKeyword.this.getSupportedTypes();
            ProblemBuilder builder = AbstractKeyword.this.createProblemBuilder(this.getContext()).withParameter("actual", (Object)this.actual);
            if (expected.size() > 1) {
                builder.withMessage(Message.INSTANCE_PROBLEM_TYPE_PLURAL).withParameter("expected", expected);
            } else {
                InstanceType first = expected.iterator().next();
                builder.withMessage(Message.INSTANCE_PROBLEM_TYPE).withParameter("expected", (Object)first);
            }
            dispatcher.dispatchProblem(builder.build());
            return Evaluator.Result.FALSE;
        }
    }
}

