/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.json.ParserEvents;
import org.leadpony.justify.internal.evaluator.AbstractConjunctivePropertiesEvaluator;
import org.leadpony.justify.internal.evaluator.AbstractDisjunctivePropertiesEvaluator;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.applicator.RedundantPropertyEvaluator;
import org.leadpony.justify.internal.keyword.applicator.UnaryCombiner;

@KeywordType(value="additionalProperties")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class AdditionalProperties
extends UnaryCombiner {
    public static KeywordMapper mapper() {
        KeywordMapper.FromSchema mapper = AdditionalProperties::new;
        return mapper;
    }

    public AdditionalProperties(JsonValue json, JsonSchema subschema) {
        super(subschema);
    }

    @Override
    public boolean supportsType(InstanceType type) {
        return type == InstanceType.OBJECT;
    }

    @Override
    public Set<InstanceType> getSupportedTypes() {
        return EnumSet.of(InstanceType.OBJECT);
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        if (this.getSubschema() == JsonSchema.FALSE) {
            return this.createForbiddenPropertiesEvaluator(context);
        }
        return this.createPropertiesEvaluator(context);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        JsonSchema subschema = this.getSubschema();
        if (subschema == JsonSchema.TRUE || subschema == JsonSchema.EMPTY) {
            return this.createNegatedForbiddenPropertiesEvaluator(context);
        }
        return this.createNegatedPropertiesEvaluator(context);
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        if (!keywords.containsKey("properties") && !keywords.containsKey("patternProperties")) {
            evaluatables.add(this);
        }
    }

    private Evaluator createPropertiesEvaluator(EvaluatorContext context) {
        final JsonSchema subschema = this.getSubschema();
        return new AbstractConjunctivePropertiesEvaluator(context){

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (ParserEvents.isValue(event)) {
                    InstanceType type = ParserEvents.toBroadInstanceType(event);
                    this.append(subschema.createEvaluator(this.getContext(), type));
                }
            }
        };
    }

    private Evaluator createNegatedPropertiesEvaluator(EvaluatorContext context) {
        final JsonSchema subschema = this.getSubschema();
        return new AbstractDisjunctivePropertiesEvaluator(context, this){

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (ParserEvents.isValue(event)) {
                    InstanceType type = ParserEvents.toBroadInstanceType(event);
                    this.append(subschema.createNegatedEvaluator(this.getContext(), type));
                }
            }
        };
    }

    private Evaluator createForbiddenPropertiesEvaluator(final EvaluatorContext context) {
        return new AbstractConjunctivePropertiesEvaluator(context){
            private String keyName;

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (event == JsonParser.Event.KEY_NAME) {
                    this.keyName = parser.getString();
                } else if (ParserEvents.isValue(event)) {
                    this.append(AdditionalProperties.this.createRedundantPropertyEvaluator(context, this.keyName));
                }
            }
        };
    }

    private Evaluator createNegatedForbiddenPropertiesEvaluator(final EvaluatorContext context) {
        return new AbstractDisjunctivePropertiesEvaluator(context, this){
            private String keyName;

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (event == JsonParser.Event.KEY_NAME) {
                    this.keyName = parser.getString();
                } else if (ParserEvents.isValue(event)) {
                    this.append(AdditionalProperties.this.createRedundantPropertyEvaluator(context, this.keyName));
                }
            }
        };
    }

    private Evaluator createRedundantPropertyEvaluator(EvaluatorContext context, String keyName) {
        return new RedundantPropertyEvaluator(context, keyName, this.getSubschema());
    }
}

