/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.internal.evaluator.LogicalEvaluator;
import org.leadpony.justify.internal.keyword.applicator.Applicator;

abstract class NaryBooleanLogic
extends Applicator {
    private final List<JsonSchema> subschemas;

    protected NaryBooleanLogic(JsonValue json, Collection<JsonSchema> subschemas) {
        super(json);
        this.subschemas = new ArrayList<JsonSchema>(subschemas);
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        return this.createLogicalEvaluator(context, type).withProblemBuilderFactory(this);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        return this.createNegatedLogicalEvaluator(context, type).withProblemBuilderFactory(this);
    }

    @Override
    public boolean isInPlace() {
        return true;
    }

    @Override
    public boolean hasSubschemas() {
        return !this.subschemas.isEmpty();
    }

    @Override
    public Stream<JsonSchema> getSubschemas() {
        return this.subschemas.stream();
    }

    @Override
    public JsonSchema getSubschema(Iterator<String> jsonPointer) {
        if (jsonPointer.hasNext()) {
            try {
                int index = Integer.parseInt(jsonPointer.next());
                if (index < this.subschemas.size()) {
                    return this.subschemas.get(index);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected abstract LogicalEvaluator createLogicalEvaluator(EvaluatorContext var1, InstanceType var2);

    protected abstract LogicalEvaluator createNegatedLogicalEvaluator(EvaluatorContext var1, InstanceType var2);
}

