/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.evaluator.EvaluatorDecorator;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.applicator.AbstractProperties;
import org.leadpony.justify.internal.keyword.applicator.PatternProperties;

@KeywordType(value="properties")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Properties
extends AbstractProperties<String> {
    private PatternProperties patternProperties;
    private Map<String, JsonValue> defaultValues;

    public static KeywordMapper mapper() {
        KeywordMapper.FromSchemaMap mapper = Properties::new;
        return mapper;
    }

    public Properties(JsonValue json, Map<String, JsonSchema> subschemas) {
        super(json, subschemas);
        for (Map.Entry<String, JsonSchema> entry : subschemas.entrySet()) {
            JsonSchema subschema = entry.getValue();
            if (!subschema.containsKeyword("default")) continue;
            this.addDefaultValue(entry.getKey(), subschema.defaultValue());
        }
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        super.addToEvaluatables(evaluatables, keywords);
        if (keywords.containsKey("patternProperties")) {
            this.patternProperties = (PatternProperties)keywords.get("patternProperties");
        }
        evaluatables.add(this);
    }

    @Override
    public JsonSchema getSubschema(Iterator<String> jsonPointer) {
        if (jsonPointer.hasNext()) {
            return (JsonSchema)this.propertyMap.get(jsonPointer.next());
        }
        return null;
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        return this.decorateEvaluator(super.doCreateEvaluator(context, type), context);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        return this.decorateEvaluator(super.doCreateNegatedEvaluator(context, type), context);
    }

    @Override
    protected boolean findSubschemas(String keyName, Consumer<JsonSchema> consumer) {
        boolean found = false;
        if (this.propertyMap.containsKey(keyName)) {
            consumer.accept((JsonSchema)this.propertyMap.get(keyName));
            found = true;
        }
        if (this.patternProperties != null && this.patternProperties.findSubschemas(keyName, consumer)) {
            found = true;
        }
        return found;
    }

    private void addDefaultValue(String key, JsonValue defaultValue) {
        if (this.defaultValues == null) {
            this.defaultValues = new LinkedHashMap<String, JsonValue>();
        }
        this.defaultValues.put(key, defaultValue);
    }

    private Evaluator decorateEvaluator(Evaluator evaluator, EvaluatorContext context) {
        if (context.acceptsDefaultValues() && this.defaultValues != null) {
            return new PropertiesDefaultEvaluator(evaluator, context, this.defaultValues);
        }
        return evaluator;
    }

    private static final class PropertiesDefaultEvaluator
    extends EvaluatorDecorator {
        private final Map<String, JsonValue> defaultValues;

        private PropertiesDefaultEvaluator(Evaluator evaluator, EvaluatorContext context, Map<String, JsonValue> defaultValues) {
            super(evaluator, context);
            this.defaultValues = new LinkedHashMap<String, JsonValue>(defaultValues);
        }

        @Override
        public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            Evaluator.Result result = super.evaluate(event, depth, dispatcher);
            if (depth == 1 && event == JsonParser.Event.KEY_NAME) {
                this.defaultValues.remove(this.getParser().getString());
            } else if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
                if (!this.defaultValues.isEmpty()) {
                    this.supplyDefaultValues();
                }
                return result;
            }
            return Evaluator.Result.PENDING;
        }

        private void supplyDefaultValues() {
            this.getContext().putDefaultProperties(this.defaultValues);
        }
    }
}

