/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.keyword.NumericKeyword;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

abstract class AbstractNumericAssertion
extends AbstractAssertion
implements NumericKeyword {
    protected AbstractNumericAssertion(JsonValue json) {
        super(json);
    }

    @Override
    protected Evaluator doCreateEvaluator(final EvaluatorContext context, InstanceType type) {
        final BigDecimal value = context.getParser().getBigDecimal();
        if (this.testValue(value)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                ProblemBuilder builder = AbstractNumericAssertion.this.createProblemBuilder(context).withParameter("actual", value);
                dispatcher.dispatchProblem(AbstractNumericAssertion.this.createProblem(builder));
                return Evaluator.Result.FALSE;
            }
        };
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(final EvaluatorContext context, InstanceType type) {
        final BigDecimal value = context.getParser().getBigDecimal();
        if (!this.testValue(value)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                ProblemBuilder builder = AbstractNumericAssertion.this.createProblemBuilder(context).withParameter("actual", value);
                dispatcher.dispatchProblem(AbstractNumericAssertion.this.createNegatedProblem(builder));
                return Evaluator.Result.FALSE;
            }
        };
    }

    protected abstract boolean testValue(BigDecimal var1);

    protected abstract Problem createProblem(ProblemBuilder var1);

    protected abstract Problem createNegatedProblem(ProblemBuilder var1);
}

