/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.StringKeyword;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

abstract class AbstractStringAssertion
extends AbstractAssertion
implements StringKeyword {
    protected AbstractStringAssertion(JsonValue json) {
        super(json);
    }

    @Override
    protected Evaluator doCreateEvaluator(final EvaluatorContext context, InstanceType type) {
        final String value = context.getParser().getString();
        if (this.testValue(value)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                ProblemBuilder builder = AbstractStringAssertion.this.createProblemBuilder(context, event, value);
                dispatcher.dispatchProblem(AbstractStringAssertion.this.createProblem(builder));
                return Evaluator.Result.FALSE;
            }
        };
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(final EvaluatorContext context, InstanceType type) {
        final String value = context.getParser().getString();
        if (!this.testValue(value)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                ProblemBuilder builder = AbstractStringAssertion.this.createProblemBuilder(context, event, value);
                dispatcher.dispatchProblem(AbstractStringAssertion.this.createNegatedProblem(builder));
                return Evaluator.Result.FALSE;
            }
        };
    }

    public ProblemBuilder createProblemBuilder(EvaluatorContext context, JsonParser.Event event, String actual) {
        ProblemBuilder builder = super.createProblemBuilder(context);
        if (event == JsonParser.Event.KEY_NAME) {
            builder.withParameter("subject", "key").withParameter("localizedSubject", Message.STRING_KEY).withParameter("actual", this.toActualValue(actual));
        } else {
            builder.withParameter("subject", "value").withParameter("localizedSubject", Message.STRING_VALUE);
        }
        builder.withParameter("actual", this.toActualValue(actual));
        return builder;
    }

    protected abstract boolean testValue(String var1);

    protected Object toActualValue(String value) {
        return value;
    }

    protected abstract Problem createProblem(ProblemBuilder var1);

    protected abstract Problem createNegatedProblem(ProblemBuilder var1);
}

