/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.assertion.AbstractStringAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

abstract class AbstractStringLengthAssertion
extends AbstractStringAssertion {
    private final int limit;
    private final Message message;
    private final Message negatedMessage;

    protected AbstractStringLengthAssertion(JsonValue json, int limit, Message message, Message negatedMessage) {
        super(json);
        this.limit = limit;
        this.message = message;
        this.negatedMessage = negatedMessage;
    }

    @Override
    protected boolean testValue(String value) {
        return this.testLength(AbstractStringLengthAssertion.countCharsIn(value), this.limit);
    }

    @Override
    protected Object toActualValue(String value) {
        return AbstractStringLengthAssertion.countCharsIn(value);
    }

    @Override
    protected Problem createProblem(ProblemBuilder builder) {
        return builder.withMessage(this.message).withParameter("limit", this.limit).build();
    }

    @Override
    protected Problem createNegatedProblem(ProblemBuilder builder) {
        return builder.withMessage(this.negatedMessage).withParameter("limit", this.limit).build();
    }

    private static int countCharsIn(String value) {
        return value.codePointCount(0, value.length());
    }

    protected abstract boolean testLength(int var1, int var2);
}

