/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.AbstractKeyword;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.assertion.Maximum;

@KeywordType(value="minimum")
@Spec(value=SpecVersion.DRAFT_04)
public class Draft04Minimum
extends Maximum {
    private boolean exclusive = false;

    public static KeywordMapper mapper() {
        KeywordMapper.FromNumber mapper = Draft04Minimum::new;
        return mapper;
    }

    public Draft04Minimum(JsonValue json, BigDecimal limit) {
        super(json, limit);
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        if (keywords.containsKey("exclusiveMinimum")) {
            ExclusiveMinimum keyword = (ExclusiveMinimum)keywords.get("exclusiveMinimum");
            this.exclusive = keyword.value;
        }
        super.addToEvaluatables(evaluatables, keywords);
    }

    @Override
    protected boolean testValue(BigDecimal actual, BigDecimal limit) {
        if (this.exclusive) {
            return actual.compareTo(limit) > 0;
        }
        return actual.compareTo(limit) >= 0;
    }

    @Override
    protected Message getMessageForTest() {
        return this.exclusive ? Message.INSTANCE_PROBLEM_EXCLUSIVEMINIMUM : Message.INSTANCE_PROBLEM_MINIMUM;
    }

    @Override
    protected Message getMessageForNegatedTest() {
        return this.exclusive ? Message.INSTANCE_PROBLEM_MAXIMUM : Message.INSTANCE_PROBLEM_EXCLUSIVEMAXIMUM;
    }

    @KeywordType(value="exclusiveMinimum")
    @Spec(value=SpecVersion.DRAFT_04)
    public static class ExclusiveMinimum
    extends AbstractKeyword {
        private final boolean value;

        public static KeywordMapper mapper() {
            KeywordMapper.FromBoolean mapper = ExclusiveMinimum::new;
            return mapper;
        }

        public ExclusiveMinimum(JsonValue json, boolean value) {
            super(json);
            this.value = value;
        }
    }
}

