/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Set;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.Type;

@KeywordType(value="type")
@Spec(value=SpecVersion.DRAFT_04)
public final class Draft04Type {
    public static KeywordMapper mapper() {
        return (value, context) -> {
            switch (value.getValueType()) {
                case STRING: {
                    return new Single(value, Type.toInstanceType((JsonString)value));
                }
                case ARRAY: {
                    LinkedHashSet<InstanceType> types = new LinkedHashSet<InstanceType>();
                    for (JsonValue item : value.asJsonArray()) {
                        if (item.getValueType() == JsonValue.ValueType.STRING) {
                            types.add(Type.toInstanceType((JsonString)item));
                            continue;
                        }
                        throw new IllegalArgumentException();
                    }
                    return new Multiple(value, types);
                }
            }
            throw new IllegalArgumentException();
        };
    }

    public static Type of(JsonValue json, InstanceType type) {
        return new Single(json, type);
    }

    public static Type of(JsonValue json, Set<InstanceType> types) {
        if (types.size() == 1) {
            return new Single(json, types.iterator().next());
        }
        return new Multiple(json, types);
    }

    private static InstanceType getNarrowType(InstanceType type, EvaluatorContext context) {
        if (type != InstanceType.NUMBER) {
            return type;
        }
        JsonParser parser = context.getParser();
        if (parser.isIntegralNumber()) {
            return InstanceType.INTEGER;
        }
        BigDecimal value = parser.getBigDecimal();
        if (value.scale() <= 0) {
            return InstanceType.INTEGER;
        }
        return type;
    }

    private Draft04Type() {
    }

    static class Single
    extends Type.Single {
        Single(JsonValue json, InstanceType expectedType) {
            super(json, expectedType);
        }

        @Override
        protected InstanceType toNarrowType(InstanceType type, EvaluatorContext context) {
            return Draft04Type.getNarrowType(type, context);
        }
    }

    static class Multiple
    extends Type.Multiple {
        Multiple(JsonValue json, Set<InstanceType> types) {
            super(json, types);
        }

        @Override
        protected InstanceType toNarrowType(InstanceType type, EvaluatorContext context) {
            return Draft04Type.getNarrowType(type, context);
        }
    }
}

