/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.evaluator.ShallowEvaluator;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.ObjectKeyword;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;
import org.leadpony.justify.internal.keyword.assertion.MaxProperties;
import org.leadpony.justify.internal.problem.ProblemBuilderFactory;

@KeywordType(value="minProperties")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class MinProperties
extends AbstractAssertion
implements ObjectKeyword {
    private final int limit;

    public static KeywordMapper mapper() {
        KeywordMapper.FromNonNegativeInteger mapper = MinProperties::new;
        return mapper;
    }

    public MinProperties(JsonValue json, int limit) {
        super(json);
        this.limit = limit;
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        return new AssertionEvaluator(context, this.limit, this);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        if (this.limit > 0) {
            return new MaxProperties.AssertionEvaluator(context, this.limit - 1, this);
        }
        return this.createAlwaysFalseEvaluator(context);
    }

    static class AssertionEvaluator
    extends ShallowEvaluator {
        private final int minProperties;
        private final ProblemBuilderFactory factory;
        private int currentCount;

        AssertionEvaluator(EvaluatorContext context, int minProperties, ProblemBuilderFactory factory) {
            super(context);
            this.minProperties = minProperties;
            this.factory = factory;
        }

        @Override
        public Evaluator.Result evaluateShallow(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            if (depth == 1) {
                if (event == JsonParser.Event.KEY_NAME && ++this.currentCount >= this.minProperties) {
                    return Evaluator.Result.TRUE;
                }
            } else if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
                if (this.currentCount >= this.minProperties) {
                    return Evaluator.Result.TRUE;
                }
                Problem p = this.factory.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_MINPROPERTIES).withParameter("actual", this.currentCount).withParameter("limit", this.minProperties).build();
                dispatcher.dispatchProblem(p);
                return Evaluator.Result.FALSE;
            }
            return Evaluator.Result.PENDING;
        }
    }
}

