/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.regex.PatternSyntaxException;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.regex.Ecma262Pattern;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractStringAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

@KeywordType(value="pattern")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Pattern
extends AbstractStringAssertion {
    private final java.util.regex.Pattern pattern;

    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                String string = ((JsonString)value).getString();
                try {
                    return new Pattern(value, Ecma262Pattern.compile(string));
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException();
        };
    }

    public Pattern(JsonValue json, java.util.regex.Pattern pattern) {
        super(json);
        this.pattern = pattern;
    }

    @Override
    protected boolean testValue(String value) {
        return this.pattern.matcher(value).find();
    }

    @Override
    protected Problem createProblem(ProblemBuilder builder) {
        return builder.withMessage(Message.INSTANCE_PROBLEM_PATTERN).withParameter("pattern", this.pattern.toString()).build();
    }

    @Override
    protected Problem createNegatedProblem(ProblemBuilder builder) {
        return builder.withMessage(Message.INSTANCE_PROBLEM_NOT_PATTERN).withParameter("pattern", this.pattern.toString()).build();
    }
}

