/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.LinkedHashSet;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.evaluator.ShallowEvaluator;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.ObjectKeyword;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;

@KeywordType(value="required")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Required
extends AbstractAssertion
implements ObjectKeyword {
    private final Set<String> names;

    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.ARRAY) {
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                for (JsonValue item : value.asJsonArray()) {
                    if (item.getValueType() == JsonValue.ValueType.STRING) {
                        names.add(((JsonString)item).getString());
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                return new Required(value, names);
            }
            throw new IllegalArgumentException();
        };
    }

    public Required(JsonValue json, Set<String> names) {
        super(json);
        this.names = new LinkedHashSet<String>(names);
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        if (this.names.isEmpty()) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new AssertionEvaluator(context, this.names);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        if (this.names.isEmpty()) {
            return this.createAlwaysFalseEvaluator(context);
        }
        return new NegatedAssertionEvaluator(context, this.names);
    }

    private final class AssertionEvaluator
    extends ShallowEvaluator {
        private final Set<String> missing;

        private AssertionEvaluator(EvaluatorContext context, Set<String> required2) {
            super(context);
            this.missing = new LinkedHashSet<String>(required2);
        }

        @Override
        public Evaluator.Result evaluateShallow(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            if (event == JsonParser.Event.KEY_NAME) {
                this.missing.remove(this.getParser().getString());
                if (this.missing.isEmpty()) {
                    return Evaluator.Result.TRUE;
                }
            } else if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
                if (this.missing.isEmpty()) {
                    return Evaluator.Result.TRUE;
                }
                return this.dispatchProblems(dispatcher);
            }
            return Evaluator.Result.PENDING;
        }

        private Evaluator.Result dispatchProblems(ProblemDispatcher dispatcher) {
            for (String property : this.missing) {
                Problem p = Required.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_REQUIRED).withParameter("required", property).build();
                dispatcher.dispatchProblem(p);
            }
            return Evaluator.Result.FALSE;
        }
    }

    private final class NegatedAssertionEvaluator
    extends ShallowEvaluator {
        private final Set<String> missing;

        private NegatedAssertionEvaluator(EvaluatorContext context, Set<String> names) {
            super(context);
            this.missing = new LinkedHashSet<String>(names);
        }

        @Override
        public Evaluator.Result evaluateShallow(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            if (event == JsonParser.Event.KEY_NAME) {
                this.missing.remove(this.getParser().getString());
                if (this.missing.isEmpty()) {
                    return this.dispatchProblem(dispatcher);
                }
            } else if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
                if (this.missing.isEmpty()) {
                    return this.dispatchProblem(dispatcher);
                }
                return Evaluator.Result.TRUE;
            }
            return Evaluator.Result.PENDING;
        }

        private Evaluator.Result dispatchProblem(ProblemDispatcher dispatcher) {
            Problem p = null;
            if (Required.this.names.size() == 1) {
                String name = (String)Required.this.names.iterator().next();
                p = Required.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_NOT_REQUIRED).withParameter("required", name).build();
            } else {
                p = Required.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_NOT_REQUIRED_PLURAL).withParameter("required", Required.this.names).build();
            }
            dispatcher.dispatchProblem(p);
            return Evaluator.Result.FALSE;
        }
    }
}

