/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;

@KeywordType(value="type")
@Specs(value={@Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public abstract class Type
extends AbstractAssertion {
    public static KeywordMapper mapper() {
        return (value, context) -> {
            switch (value.getValueType()) {
                case STRING: {
                    return new Single(value, Type.toInstanceType((JsonString)value));
                }
                case ARRAY: {
                    LinkedHashSet<InstanceType> types = new LinkedHashSet<InstanceType>();
                    for (JsonValue item : value.asJsonArray()) {
                        if (item.getValueType() == JsonValue.ValueType.STRING) {
                            types.add(Type.toInstanceType((JsonString)item));
                            continue;
                        }
                        throw new IllegalArgumentException();
                    }
                    return new Multiple(value, types);
                }
            }
            throw new IllegalArgumentException();
        };
    }

    public static Type of(JsonValue json, InstanceType type) {
        return new Single(json, type);
    }

    public static Type of(JsonValue json, Set<InstanceType> types) {
        if (types.size() == 1) {
            return new Single(json, types.iterator().next());
        }
        return new Multiple(json, types);
    }

    protected InstanceType toNarrowType(InstanceType type, EvaluatorContext context) {
        if (type != InstanceType.NUMBER) {
            return type;
        }
        JsonParser parser = context.getParser();
        if (parser.isIntegralNumber()) {
            return InstanceType.INTEGER;
        }
        BigDecimal value = parser.getBigDecimal().stripTrailingZeros();
        if (value.scale() <= 0) {
            return InstanceType.INTEGER;
        }
        return type;
    }

    static InstanceType toInstanceType(JsonString value) {
        String name = value.getString().toUpperCase();
        return InstanceType.valueOf(name);
    }

    protected Type(JsonValue json) {
        super(json);
    }

    static class Single
    extends Type {
        private final InstanceType expectedType;

        Single(JsonValue json, InstanceType expectedType) {
            super(json);
            this.expectedType = expectedType;
        }

        @Override
        protected Evaluator doCreateEvaluator(final EvaluatorContext context, InstanceType type) {
            final InstanceType narrowerType = this.toNarrowType(type, context);
            if (this.testType(narrowerType)) {
                return Evaluator.ALWAYS_TRUE;
            }
            return new Evaluator(){

                @Override
                public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                    Problem p = this.createProblemBuilder(context).withMessage(Message.INSTANCE_PROBLEM_TYPE).withParameter("actual", (Object)narrowerType).withParameter("expected", (Object)expectedType).build();
                    dispatcher.dispatchProblem(p);
                    return Evaluator.Result.FALSE;
                }
            };
        }

        @Override
        protected Evaluator doCreateNegatedEvaluator(final EvaluatorContext context, InstanceType type) {
            InstanceType narrowerType = this.toNarrowType(type, context);
            if (!this.testType(narrowerType)) {
                return Evaluator.ALWAYS_TRUE;
            }
            return new Evaluator(){

                @Override
                public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                    Problem p = this.createProblemBuilder(context).withMessage(Message.INSTANCE_PROBLEM_NOT_TYPE).withParameter("expected", (Object)expectedType).build();
                    dispatcher.dispatchProblem(p);
                    return Evaluator.Result.FALSE;
                }
            };
        }

        private boolean testType(InstanceType type) {
            if (type == this.expectedType) {
                return true;
            }
            if (type == InstanceType.INTEGER) {
                return this.expectedType == InstanceType.NUMBER;
            }
            return false;
        }
    }

    static class Multiple
    extends Type {
        private final Set<InstanceType> expectedTypes;

        Multiple(JsonValue json, Set<InstanceType> types) {
            super(json);
            this.expectedTypes = new LinkedHashSet<InstanceType>(types);
        }

        @Override
        protected Evaluator doCreateEvaluator(final EvaluatorContext context, InstanceType type) {
            final InstanceType narrowerType = this.toNarrowType(type, context);
            if (this.testType(narrowerType)) {
                return Evaluator.ALWAYS_TRUE;
            }
            return new Evaluator(){

                @Override
                public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                    Problem p = this.createProblemBuilder(context).withMessage(Message.INSTANCE_PROBLEM_TYPE_PLURAL).withParameter("actual", (Object)narrowerType).withParameter("expected", expectedTypes).build();
                    dispatcher.dispatchProblem(p);
                    return Evaluator.Result.FALSE;
                }
            };
        }

        @Override
        protected Evaluator doCreateNegatedEvaluator(final EvaluatorContext context, InstanceType type) {
            final InstanceType narrowerType = this.toNarrowType(type, context);
            if (!this.testType(narrowerType)) {
                return Evaluator.ALWAYS_TRUE;
            }
            return new Evaluator(){

                @Override
                public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                    Problem p = this.createProblemBuilder(context).withMessage(Message.INSTANCE_PROBLEM_NOT_TYPE_PLURAL).withParameter("actual", (Object)narrowerType).withParameter("expected", expectedTypes).build();
                    dispatcher.dispatchProblem(p);
                    return Evaluator.Result.FALSE;
                }
            };
        }

        private boolean testType(InstanceType type) {
            return this.expectedTypes.contains((Object)type) || type == InstanceType.INTEGER && this.expectedTypes.contains((Object)InstanceType.NUMBER);
        }
    }
}

