/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.content;

import java.util.Base64;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.spi.ContentEncodingScheme;

class Base64
implements ContentEncodingScheme {
    Base64() {
    }

    @Override
    public String name() {
        return "base64";
    }

    @Override
    public boolean canDecode(String src) {
        Arguments.requireNonNull(src, "src");
        int length = src.length();
        if (length % 4 != 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            char c;
            if ((c = src.charAt(i++)) == '=') {
                int pads = 1;
                while (i < length) {
                    if ((c = src.charAt(i++)) == '=' && ++pads <= 3) continue;
                    return false;
                }
                break;
            }
            if (AsciiCode.isAlphanumeric(c) || c == '+' || c == '/') continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] decode(String src) {
        Arguments.requireNonNull(src, "src");
        if (src.length() % 4 != 0) {
            throw new IllegalArgumentException();
        }
        return Base64.getDecoder().decode(src);
    }

    private static Base64.Decoder getDecoder() {
        return java.util.Base64.getDecoder();
    }
}

