/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.content;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;
import org.leadpony.justify.internal.keyword.assertion.content.UnknownContentEncoding;
import org.leadpony.justify.spi.ContentEncodingScheme;

@KeywordType(value="contentEncoding")
@Spec(value=SpecVersion.DRAFT_07)
public class ContentEncoding
extends AbstractAssertion {
    private final ContentEncodingScheme scheme;

    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                String name = ((JsonString)value).getString();
                ContentEncodingScheme scheme = context.getEncodingScheme(name);
                if (scheme != null) {
                    return new ContentEncoding(value, scheme);
                }
                return new UnknownContentEncoding(value, name);
            }
            throw new IllegalArgumentException();
        };
    }

    public ContentEncoding(JsonValue json, ContentEncodingScheme scheme) {
        super(json);
        assert (scheme != null);
        this.scheme = scheme;
    }

    @Override
    public boolean supportsType(InstanceType type) {
        return type == InstanceType.STRING;
    }

    @Override
    public Set<InstanceType> getSupportedTypes() {
        return EnumSet.of(InstanceType.STRING);
    }

    @Override
    protected Evaluator doCreateEvaluator(final EvaluatorContext context, InstanceType type) {
        if (this.test(context.getParser().getString())) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                dispatcher.dispatchProblem(ContentEncoding.this.buildProblem(context, Message.INSTANCE_PROBLEM_CONTENTENCODING));
                return Evaluator.Result.FALSE;
            }
        };
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(final EvaluatorContext context, InstanceType type) {
        if (!this.test(context.getParser().getString())) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                dispatcher.dispatchProblem(ContentEncoding.this.buildProblem(context, Message.INSTANCE_PROBLEM_NOT_CONTENTENCODING));
                return Evaluator.Result.FALSE;
            }
        };
    }

    private boolean test(String src) {
        return this.scheme.canDecode(src);
    }

    ContentEncodingScheme scheme() {
        return this.scheme;
    }

    private Problem buildProblem(EvaluatorContext context, Message message) {
        return this.createProblemBuilder(context).withMessage(message).withParameter("encoding", this.scheme.name()).build();
    }
}

