/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.content;

import jakarta.json.JsonException;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.leadpony.justify.spi.ContentMimeType;

class JsonMimeType
implements ContentMimeType {
    private final JsonProvider jsonProvider;

    JsonMimeType(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    @Override
    public String toString() {
        return "application/json";
    }

    @Override
    public boolean test(String content) {
        boolean bl;
        block8: {
            JsonParser parser = this.jsonProvider.createParser((Reader)new StringReader(content));
            try {
                bl = JsonMimeType.parseAllWith(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException e) {
                    return false;
                }
            }
            parser.close();
        }
        return bl;
    }

    @Override
    public boolean test(byte[] decodedContent, Map<String, String> parameters) {
        boolean bl;
        block8: {
            JsonParser parser = this.jsonProvider.createParser((InputStream)new ByteArrayInputStream(decodedContent));
            try {
                bl = JsonMimeType.parseAllWith(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException e) {
                    return false;
                }
            }
            parser.close();
        }
        return bl;
    }

    private static boolean parseAllWith(JsonParser parser) {
        while (parser.hasNext()) {
            parser.next();
        }
        return true;
    }
}

