/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.api.Localizable;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatAttribute;
import org.leadpony.justify.internal.keyword.assertion.format.Date;
import org.leadpony.justify.internal.keyword.assertion.format.Time;

@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
class DateTime
extends AbstractFormatAttribute {
    private final Date date = new Date();
    private final Time time = new Time();

    DateTime() {
    }

    @Override
    public String name() {
        return "date-time";
    }

    @Override
    public Localizable localizedName() {
        return Message.FORMAT_DATE_TIME;
    }

    @Override
    public boolean test(String value) {
        String[] parts = value.split("T|t", 3);
        if (parts.length != 2) {
            return false;
        }
        return this.date.test(parts[0]) && this.time.test(parts[1]);
    }
}

