/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatMatcher;

class DurationMatcher
extends AbstractFormatMatcher {
    DurationMatcher(CharSequence input) {
        super(input);
    }

    @Override
    boolean test() {
        if (this.hasNext(80)) {
            this.next();
            if (this.hasNext() && (this.date() || this.time() || this.week())) {
                return !this.hasNext();
            }
        }
        return false;
    }

    private boolean digits() {
        int length = 0;
        while (this.hasNext() && AsciiCode.isDigit(this.peek())) {
            this.next();
            ++length;
        }
        return length > 0;
    }

    private boolean date() {
        int offset = this.pos();
        if (!this.digits()) {
            return false;
        }
        int units = 0;
        int c = this.next();
        if (c == 89) {
            ++units;
            if (this.digits()) {
                c = this.next();
            } else {
                return true;
            }
        }
        if (c == 77) {
            ++units;
            if (this.digits()) {
                c = this.next();
            } else {
                return true;
            }
        }
        if (c == 68) {
            ++units;
            this.time();
            return true;
        }
        if (units > 0) {
            return DurationMatcher.fail();
        }
        return this.backtrack(offset);
    }

    private boolean time() {
        if (!this.hasNext(84)) {
            return false;
        }
        this.next();
        if (this.digits()) {
            int c = this.next();
            if (c == 72) {
                if (this.digits()) {
                    c = this.next();
                } else {
                    return true;
                }
            }
            if (c == 77) {
                if (this.digits()) {
                    c = this.next();
                } else {
                    return true;
                }
            }
            if (c == 83) {
                return true;
            }
        }
        return DurationMatcher.fail();
    }

    private boolean week() {
        int offset = this.pos();
        if (this.digits() && this.next() == 87) {
            return true;
        }
        return this.backtrack(offset);
    }
}

