/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.BitSet;
import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatMatcher;
import org.leadpony.justify.internal.keyword.assertion.format.HostnameMatcher;

class EmailMatcher
extends AbstractFormatMatcher {
    static final int MAX_LOCAL_PART_CHARS = 64;
    static final String ATOM_TEXT_CHARS = "!#$%&'*+-/=?^_`{|}~";
    static final BitSet ATOM_TEXT_CHARSET = new BitSet(128){
        {
            for (int i = 0; i < EmailMatcher.ATOM_TEXT_CHARS.length(); ++i) {
                this.set(EmailMatcher.ATOM_TEXT_CHARS.charAt(i));
            }
        }
    };

    EmailMatcher(CharSequence input) {
        super(input);
    }

    @Override
    public boolean test() {
        this.localPart();
        if (this.next() == 64) {
            this.domainPart();
            return true;
        }
        return false;
    }

    private void localPart() {
        int start = this.pos();
        this.zeroOrMoreComments();
        if (this.peek() == 34) {
            this.quotedString();
        } else {
            this.dotAtom();
        }
        this.zeroOrMoreComments();
        int length = this.pos() - start;
        if (length > 64) {
            EmailMatcher.fail();
        }
    }

    private void dotAtom() {
        this.atomText();
        while (this.peek() == 46) {
            this.next();
            this.atomText();
        }
    }

    private void atomText() {
        int c;
        int length = 0;
        while ((c = this.peek()) != 64 && c != 46 && c != 40 && !EmailMatcher.isWhiteSpace(c) && c != 13) {
            this.next();
            if (this.checkAtomLetter(c)) {
                ++length;
                continue;
            }
            EmailMatcher.fail();
        }
        if (length == 0) {
            EmailMatcher.fail();
        }
    }

    private void quotedString() {
        int c = this.next();
        while ((c = this.next()) != 34) {
            if (c == 92) {
                if (this.checkQuotedLetter(this.next())) continue;
                EmailMatcher.fail();
                continue;
            }
            if (EmailMatcher.isWhiteSpace(c) || c == 13) {
                this.foldingWhiteSpace();
                continue;
            }
            if (this.checkQuotedLetter(c)) continue;
            EmailMatcher.fail();
        }
    }

    private void domainPart() {
        int length;
        int start = this.pos();
        this.zeroOrMoreComments();
        if (this.peek() == 91) {
            this.domainLiteral();
        } else {
            this.hostname();
        }
        this.zeroOrMoreComments();
        if (this.hasNext()) {
            EmailMatcher.fail();
        }
        if ((length = this.pos() - start) > 253) {
            EmailMatcher.fail();
        }
    }

    private void domainLiteral() {
        int c = this.next();
        while ((c = this.next()) != 93) {
            if (EmailMatcher.isWhiteSpace(c) || c == 13) {
                this.foldingWhiteSpace();
                continue;
            }
            if (this.checkDomainLiteralLetter(c)) continue;
            EmailMatcher.fail();
        }
    }

    private void hostname() {
        int c;
        int start = this.pos();
        while (this.hasNext() && (c = this.peek()) != 40 && !EmailMatcher.isWhiteSpace(c) && c != 13) {
            this.next();
        }
        if (!this.checkHostname(start, this.pos())) {
            EmailMatcher.fail();
        }
    }

    private void zeroOrMoreComments() {
        this.foldingWhiteSpace();
        if (this.hasNext() && this.peek() == 40) {
            this.comment();
            this.foldingWhiteSpace();
            while (this.hasNext() && this.peek() == 40) {
                this.comment();
                this.foldingWhiteSpace();
            }
        }
    }

    private void comment() {
        this.next();
        while (true) {
            int c;
            if ((c = this.peek()) == 40) {
                this.comment();
                continue;
            }
            if (EmailMatcher.isWhiteSpace(c) || c == 13) {
                this.foldingWhiteSpace();
                continue;
            }
            this.next();
            if (c == 41) break;
            if (c == 92) {
                if (this.checkQuotedLetter(this.next())) continue;
                EmailMatcher.fail();
                continue;
            }
            if (this.checkCommentLetter(c)) continue;
            EmailMatcher.fail();
        }
    }

    private void foldingWhiteSpace() {
        this.zeroOrMoreWhiteSpaces();
        if (this.hasNext() && this.peek() == 13) {
            if (this.next() != 110) {
                EmailMatcher.fail();
            }
            if (EmailMatcher.isWhiteSpace(this.next())) {
                this.zeroOrMoreWhiteSpaces();
            } else {
                EmailMatcher.fail();
            }
        }
    }

    private void zeroOrMoreWhiteSpaces() {
        while (this.hasNext() && EmailMatcher.isWhiteSpace(this.peek())) {
            this.next();
        }
    }

    protected boolean checkQuotedLetter(int c) {
        return c >= 32 && c < 127;
    }

    protected boolean checkAtomLetter(int c) {
        return AsciiCode.isAlphanumeric(c) || ATOM_TEXT_CHARSET.get(c);
    }

    protected boolean checkDomainLiteralLetter(int c) {
        return c >= 33 && c <= 90 || c >= 94 && c <= 126;
    }

    protected boolean checkCommentLetter(int c) {
        return EmailMatcher.isNonWhiteSpaceControl(c) || c >= 33 && c <= 39 || c >= 42 && c <= 91 || c >= 93 && c <= 126;
    }

    protected boolean checkHostname(int start, int end) {
        return new HostnameMatcher(this.input(), start, end).matches();
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9;
    }

    private static boolean isNonWhiteSpaceControl(int c) {
        return c >= 1 && c <= 9 || c == 11 || c == 12 || c >= 14 && c <= 31 || c == 127;
    }
}

