/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.assertion.format.Format;
import org.leadpony.justify.internal.problem.ProblemBuilder;
import org.leadpony.justify.spi.FormatAttribute;

public class EvaluatableFormat
extends Format {
    private final FormatAttribute attribute;

    public EvaluatableFormat(JsonValue json, FormatAttribute attribute) {
        super(json, attribute.name());
        this.attribute = attribute;
    }

    @Override
    public boolean supportsType(InstanceType type) {
        return type == this.attribute.valueType();
    }

    @Override
    public Set<InstanceType> getSupportedTypes() {
        return EnumSet.of(this.attribute.valueType());
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        evaluatables.add(this);
    }

    @Override
    protected Evaluator doCreateEvaluator(final EvaluatorContext context, InstanceType type) {
        JsonValue value = context.getParser().getValue();
        if (this.test(value)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                ProblemBuilder builder = EvaluatableFormat.this.createProblemBuilder(context).withMessage(Message.INSTANCE_PROBLEM_FORMAT);
                dispatcher.dispatchProblem(builder.build());
                return Evaluator.Result.FALSE;
            }
        };
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(final EvaluatorContext context, InstanceType type) {
        JsonValue value = context.getParser().getValue();
        if (!this.test(value)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                ProblemBuilder builder = EvaluatableFormat.this.createProblemBuilder(context).withMessage(Message.INSTANCE_PROBLEM_NOT_FORMAT);
                dispatcher.dispatchProblem(builder.build());
                return Evaluator.Result.FALSE;
            }
        };
    }

    @Override
    public ProblemBuilder createProblemBuilder(EvaluatorContext context) {
        return super.createProblemBuilder(context).withParameter("attribute", this.attribute.name()).withParameter("localizedAttribute", this.attribute.localizedName());
    }

    private boolean test(JsonValue value) {
        return this.attribute.test(value);
    }
}

